/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.data;

import android.content.Context;
import android.widget.TextView;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.util.ui.PreambleHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PrivacyDisclosureUtils {
    private static final int NO_TOS_OR_PP = -1;

    public static void setupTermsOfServiceAndPrivacyPolicyText(Context context, FlowParameters flowParameters, TextView termsText) {
        PreambleHandler.setup(context, flowParameters, PrivacyDisclosureUtils.getGlobalTermsStringResource(flowParameters), termsText);
    }

    public static void setupTermsOfServiceFooter(Context context, FlowParameters flowParameters, TextView footerText) {
        PreambleHandler.setup(context, flowParameters, PrivacyDisclosureUtils.getGlobalTermsFooterStringResource(flowParameters), footerText);
    }

    public static void setupTermsOfServiceAndPrivacyPolicySmsText(Context context, FlowParameters flowParameters, TextView termsText) {
        PreambleHandler.setup(context, flowParameters, R.string.fui_verify_phone_number, PrivacyDisclosureUtils.getTermsSmsStringResource(flowParameters), termsText);
    }

    @StringRes
    private static int getGlobalTermsStringResource(FlowParameters flowParameters) {
        boolean termsOfServiceUrlProvided = flowParameters.isTermsOfServiceUrlProvided();
        boolean privacyPolicyUrlProvided = flowParameters.isPrivacyPolicyUrlProvided();
        if (termsOfServiceUrlProvided && privacyPolicyUrlProvided) {
            return R.string.fui_tos_and_pp;
        }
        return -1;
    }

    @StringRes
    private static int getGlobalTermsFooterStringResource(FlowParameters flowParameters) {
        boolean termsOfServiceUrlProvided = flowParameters.isTermsOfServiceUrlProvided();
        boolean privacyPolicyUrlProvided = flowParameters.isPrivacyPolicyUrlProvided();
        if (termsOfServiceUrlProvided && privacyPolicyUrlProvided) {
            return R.string.fui_tos_and_pp_footer;
        }
        return -1;
    }

    @StringRes
    private static int getTermsSmsStringResource(FlowParameters flowParameters) {
        boolean termsOfServiceUrlProvided = flowParameters.isTermsOfServiceUrlProvided();
        boolean privacyPolicyUrlProvided = flowParameters.isPrivacyPolicyUrlProvided();
        if (termsOfServiceUrlProvided && privacyPolicyUrlProvided) {
            return R.string.fui_sms_terms_of_service_and_privacy_policy_extended;
        }
        return -1;
    }
}

