/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.data;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.gms.common.internal.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkParser {
    private static String LINK = "link";
    private static final String OOB_CODE = "oobCode";
    private static final String CONTINUE_URL = "continueUrl";
    private Map<String, String> mParams;

    public EmailLinkParser(@NonNull String link) {
        Preconditions.checkNotEmpty((String)link);
        this.mParams = this.parseUri(Uri.parse((String)link));
        if (this.mParams.isEmpty()) {
            throw new IllegalArgumentException("Invalid link: no parameters found");
        }
    }

    public String getOobCode() {
        return this.mParams.get(OOB_CODE);
    }

    public String getSessionId() {
        return this.mParams.get("ui_sid");
    }

    public String getAnonymousUserId() {
        return this.mParams.get("ui_auid");
    }

    public boolean getForceSameDeviceBit() {
        String forceSameDeviceBit = this.mParams.get("ui_sd");
        if (TextUtils.isEmpty((CharSequence)forceSameDeviceBit)) {
            return false;
        }
        return forceSameDeviceBit.equals("1");
    }

    public String getProviderId() {
        return this.mParams.get("ui_pid");
    }

    private Map<String, String> parseUri(Uri uri) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Set queryParameters = uri.getQueryParameterNames();
            for (String param : queryParameters) {
                if (param.equalsIgnoreCase(LINK) || param.equalsIgnoreCase(CONTINUE_URL)) {
                    Uri innerUri = Uri.parse((String)uri.getQueryParameter(param));
                    Map<String, String> innerValues = this.parseUri(innerUri);
                    if (innerValues == null) continue;
                    map.putAll(innerValues);
                    continue;
                }
                String value = uri.getQueryParameter(param);
                if (value == null) continue;
                map.put(param, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static class LinkParameters {
        public static final String SESSION_IDENTIFIER = "ui_sid";
        public static final String ANONYMOUS_USER_ID_IDENTIFIER = "ui_auid";
        public static final String FORCE_SAME_DEVICE_IDENTIFIER = "ui_sd";
        public static final String PROVIDER_ID_IDENTIFIER = "ui_pid";
    }
}

