/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.style.ScaleXSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import com.firebase.ui.auth.R;
import com.google.android.material.textfield.TextInputEditText;

public final class SpacedEditText
extends TextInputEditText {
    private float mProportion;
    private SpannableStringBuilder mOriginalText = new SpannableStringBuilder((CharSequence)"");

    public SpacedEditText(Context context) {
        super(context);
    }

    public SpacedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    void initAttrs(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SpacedEditText);
        this.mProportion = array.getFloat(R.styleable.SpacedEditText_spacingProportion, 1.0f);
        array.recycle();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.mOriginalText = new SpannableStringBuilder(text);
        super.setText((CharSequence)this.getSpacedOutString(text), TextView.BufferType.SPANNABLE);
    }

    public void setSelection(int index) {
        int newIndex = index * 2 - 1;
        newIndex = Math.max(newIndex, 0);
        newIndex = Math.min(newIndex, this.mOriginalText.length() * 2 - 1);
        try {
            super.setSelection(newIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage() + ", requestedIndex=" + index + ", newIndex= " + newIndex + ", originalText=" + this.mOriginalText);
        }
    }

    private SpannableStringBuilder getSpacedOutString(CharSequence text) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        int textLength = text.length();
        int lastSpaceIndex = -1;
        for (int i = 0; i < textLength - 1; ++i) {
            builder.append(text.charAt(i));
            builder.append((CharSequence)" ");
            builder.setSpan((Object)new ScaleXSpan(this.mProportion), lastSpaceIndex += 2, lastSpaceIndex + 1, 33);
        }
        if (textLength != 0) {
            builder.append(text.charAt(textLength - 1));
        }
        return builder;
    }

    public Editable getUnspacedText() {
        return this.mOriginalText;
    }
}

