/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.ListPopupWindow;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.CountryInfo;
import com.firebase.ui.auth.util.data.PhoneNumberUtils;
import com.google.android.material.textfield.TextInputEditText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class CountryListSpinner
extends TextInputEditText
implements View.OnClickListener {
    private static final String KEY_SUPER_STATE = "KEY_SUPER_STATE";
    private static final String KEY_COUNTRY_INFO = "KEY_COUNTRY_INFO";
    private final ArrayAdapter<CountryInfo> mCountryListAdapter;
    private View.OnClickListener mListener;
    private CountryInfo mSelectedCountryInfo;
    private ListPopupWindow mListPopupWindow;
    private Set<String> mAllowedCountryIsos = new HashSet<String>();
    private Set<String> mBlockedCountryIsos = new HashSet<String>();

    public CountryListSpinner(Context context) {
        this(context, null);
    }

    public CountryListSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public CountryListSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnClickListener((View.OnClickListener)this);
        this.mCountryListAdapter = new ArrayAdapter(this.getContext(), R.layout.fui_dgts_country_row, 16908308);
        this.mListPopupWindow = new ListPopupWindow(context, null, R.attr.listPopupWindowStyle);
        this.mListPopupWindow.setModal(true);
        this.setInputType(0);
        this.mListPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CountryInfo info = (CountryInfo)CountryListSpinner.this.mCountryListAdapter.getItem(position);
                if (info != null) {
                    CountryListSpinner.this.setText(info.toShortString());
                }
                CountryListSpinner.this.onUnfocus();
            }
        });
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.onFocus();
        } else {
            this.onUnfocus();
        }
    }

    private void onFocus() {
        CountryListSpinner.hideKeyboard(this.getContext(), (View)this);
        this.mListPopupWindow.show();
    }

    private void onUnfocus() {
        this.mListPopupWindow.dismiss();
    }

    public void init(Bundle params, View anchorView) {
        if (params != null) {
            List<CountryInfo> countries = this.getCountriesToDisplayInSpinner(params);
            this.setCountriesToDisplay(countries);
            this.setDefaultCountryForSpinner(countries);
            this.mListPopupWindow.setAnchorView(anchorView);
            this.mListPopupWindow.setAdapter(this.mCountryListAdapter);
        }
    }

    private List<CountryInfo> getCountriesToDisplayInSpinner(Bundle params) {
        this.initCountrySpinnerIsosFromParams(params);
        Map<String, Integer> countryInfoMap = PhoneNumberUtils.getImmutableCountryIsoMap();
        if (this.mAllowedCountryIsos.isEmpty() && this.mBlockedCountryIsos.isEmpty()) {
            this.mAllowedCountryIsos = new HashSet<String>(countryInfoMap.keySet());
        }
        ArrayList<CountryInfo> countryInfoList = new ArrayList<CountryInfo>();
        HashSet<String> excludedCountries = new HashSet<String>();
        if (!this.mBlockedCountryIsos.isEmpty()) {
            excludedCountries.addAll(this.mBlockedCountryIsos);
        } else {
            excludedCountries.addAll(countryInfoMap.keySet());
            excludedCountries.removeAll(this.mAllowedCountryIsos);
        }
        for (String countryIso : countryInfoMap.keySet()) {
            if (excludedCountries.contains(countryIso)) continue;
            countryInfoList.add(new CountryInfo(new Locale("", countryIso), countryInfoMap.get(countryIso)));
        }
        Collections.sort(countryInfoList);
        return countryInfoList;
    }

    private void initCountrySpinnerIsosFromParams(@NonNull Bundle params) {
        ArrayList allowedCountries = params.getStringArrayList("allowlisted_countries");
        ArrayList blockedCountries = params.getStringArrayList("blocklisted_countries");
        if (allowedCountries != null) {
            this.mAllowedCountryIsos = this.convertCodesToIsos(allowedCountries);
        }
        if (blockedCountries != null) {
            this.mBlockedCountryIsos = this.convertCodesToIsos(blockedCountries);
        }
    }

    private Set<String> convertCodesToIsos(@NonNull List<String> codes) {
        HashSet<String> isos = new HashSet<String>();
        for (String code : codes) {
            if (PhoneNumberUtils.isValid(code)) {
                isos.addAll(PhoneNumberUtils.getCountryIsosFromCountryCode(code));
                continue;
            }
            isos.add(code);
        }
        return isos;
    }

    public void setCountriesToDisplay(List<CountryInfo> countries) {
        this.mCountryListAdapter.addAll(countries);
        this.mCountryListAdapter.notifyDataSetChanged();
    }

    private void setDefaultCountryForSpinner(List<CountryInfo> countries) {
        CountryInfo countryInfo = PhoneNumberUtils.getCurrentCountryInfo(this.getContext());
        if (this.isValidIso(countryInfo.getLocale().getCountry())) {
            this.setSelectedForCountry(countryInfo.getCountryCode(), countryInfo.getLocale());
        } else if (countries.iterator().hasNext()) {
            countryInfo = countries.iterator().next();
            this.setSelectedForCountry(countryInfo.getCountryCode(), countryInfo.getLocale());
        }
    }

    public boolean isValidIso(String iso) {
        iso = iso.toUpperCase(Locale.getDefault());
        boolean valid = true;
        if (!this.mAllowedCountryIsos.isEmpty()) {
            boolean bl = valid = valid && this.mAllowedCountryIsos.contains(iso);
        }
        if (!this.mBlockedCountryIsos.isEmpty()) {
            valid = valid && !this.mBlockedCountryIsos.contains(iso);
        }
        return valid;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        bundle.putParcelable(KEY_COUNTRY_INFO, (Parcelable)this.mSelectedCountryInfo);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof Bundle)) {
            super.onRestoreInstanceState(state);
            return;
        }
        Bundle bundle = (Bundle)state;
        Parcelable superState = bundle.getParcelable(KEY_SUPER_STATE);
        this.mSelectedCountryInfo = (CountryInfo)bundle.getParcelable(KEY_COUNTRY_INFO);
        super.onRestoreInstanceState(superState);
    }

    private static void hideKeyboard(Context context, View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void setSelectedForCountry(int countryCode, Locale locale) {
        this.mSelectedCountryInfo = new CountryInfo(locale, countryCode);
        this.setText(this.mSelectedCountryInfo.toShortString());
    }

    public void setSelectedForCountry(Locale locale, String countryCode) {
        String countryName;
        if (this.isValidIso(locale.getCountry()) && !TextUtils.isEmpty((CharSequence)(countryName = locale.getDisplayName())) && !TextUtils.isEmpty((CharSequence)countryCode)) {
            this.setSelectedForCountry(Integer.parseInt(countryCode), locale);
        }
    }

    public CountryInfo getSelectedCountryInfo() {
        return this.mSelectedCountryInfo;
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mListener = l;
    }

    public void onClick(View view) {
        CountryListSpinner.hideKeyboard(this.getContext(), (View)this);
        this.executeUserClickListener(view);
    }

    private void executeUserClickListener(View view) {
        if (this.mListener != null) {
            this.mListener.onClick(view);
        }
        this.onFocus();
    }
}

