/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TroubleSigningInFragment
extends FragmentBase
implements View.OnClickListener {
    public static final String TAG = "TroubleSigningInFragment";
    private ResendEmailListener mListener;
    private ProgressBar mProgressBar;
    private String mEmail;

    public static TroubleSigningInFragment newInstance(@NonNull String email) {
        TroubleSigningInFragment fragment = new TroubleSigningInFragment();
        Bundle args = new Bundle();
        args.putString("extra_email", email);
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_email_link_trouble_signing_in_layout, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        FragmentActivity activity = this.getActivity();
        if (!(activity instanceof ResendEmailListener)) {
            throw new IllegalStateException("Activity must implement ResendEmailListener");
        }
        this.mListener = (ResendEmailListener)activity;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mEmail = this.getArguments().getString("extra_email");
        this.setOnClickListeners(view);
        this.setPrivacyFooter(view);
    }

    private void setOnClickListeners(View view) {
        view.findViewById(R.id.button_resend_email).setOnClickListener((View.OnClickListener)this);
    }

    private void setPrivacyFooter(View view) {
        TextView footerText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), this.getFlowParams(), footerText);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.button_resend_email) {
            this.mListener.onClickResendEmail(this.mEmail);
        }
    }

    @Override
    public void showProgress(int message) {
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mProgressBar.setVisibility(4);
    }

    static interface ResendEmailListener {
        public void onClickResendEmail(String var1);
    }
}

