/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.InvisibleFragmentBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.TextHelper;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.email.EmailLinkSendEmailHandler;
import com.google.firebase.auth.ActionCodeSettings;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkFragment
extends InvisibleFragmentBase {
    public static final String TAG = "EmailLinkFragment";
    private static final String EMAIL_SENT = "emailSent";
    private EmailLinkSendEmailHandler mEmailLinkSendEmailHandler;
    private TroubleSigningInListener mListener;
    private ScrollView mTopLevelView;
    private boolean mEmailSent;

    public static EmailLinkFragment newInstance(@NonNull String email, @NonNull ActionCodeSettings settings) {
        return EmailLinkFragment.newInstance(email, settings, null, false);
    }

    public static EmailLinkFragment newInstance(@NonNull String email, @NonNull ActionCodeSettings actionCodeSettings, @Nullable IdpResponse idpResponseForLinking, boolean forceSameDevice) {
        EmailLinkFragment fragment = new EmailLinkFragment();
        Bundle args = new Bundle();
        args.putString("extra_email", email);
        args.putParcelable("action_code_settings", (Parcelable)actionCodeSettings);
        args.putParcelable("extra_idp_response", (Parcelable)idpResponseForLinking);
        args.putBoolean("force_same_device", forceSameDevice);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        FragmentActivity activity = this.getActivity();
        if (!(activity instanceof TroubleSigningInListener)) {
            throw new IllegalStateException("Activity must implement TroubleSigningInListener");
        }
        this.mListener = (TroubleSigningInListener)activity;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_email_link_sign_in_layout, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            this.mEmailSent = savedInstanceState.getBoolean(EMAIL_SENT);
        }
        this.mTopLevelView = (ScrollView)view.findViewById(R.id.top_level_view);
        if (!this.mEmailSent) {
            this.mTopLevelView.setVisibility(8);
        }
        String email = this.getArguments().getString("extra_email");
        this.setBodyText(view, email);
        this.setOnClickListeners(view, email);
        this.setPrivacyFooter(view);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initHandler();
        String email = this.getArguments().getString("extra_email");
        ActionCodeSettings actionCodeSettings = (ActionCodeSettings)this.getArguments().getParcelable("action_code_settings");
        IdpResponse idpResponseForLinking = (IdpResponse)this.getArguments().getParcelable("extra_idp_response");
        boolean forceSameDevice = this.getArguments().getBoolean("force_same_device");
        if (!this.mEmailSent) {
            this.mEmailLinkSendEmailHandler.sendSignInLinkToEmail(email, actionCodeSettings, idpResponseForLinking, forceSameDevice);
        }
    }

    private void initHandler() {
        this.mEmailLinkSendEmailHandler = (EmailLinkSendEmailHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(EmailLinkSendEmailHandler.class);
        this.mEmailLinkSendEmailHandler.init(this.getFlowParams());
        this.mEmailLinkSendEmailHandler.getOperation().observe(this.getViewLifecycleOwner(), (Observer)new ResourceObserver<String>((FragmentBase)this, R.string.fui_progress_dialog_sending){

            @Override
            protected void onSuccess(@NonNull String email) {
                Log.w((String)EmailLinkFragment.TAG, (String)"Email for email link sign in sent successfully.");
                EmailLinkFragment.this.doAfterTimeout(() -> EmailLinkFragment.this.mTopLevelView.setVisibility(0));
                EmailLinkFragment.this.mEmailSent = true;
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                EmailLinkFragment.this.mListener.onSendEmailFailure(e);
            }
        });
    }

    private void setBodyText(View view, String email) {
        TextView body = (TextView)view.findViewById(R.id.sign_in_email_sent_text);
        String bodyText = this.getString(R.string.fui_email_link_email_sent, new Object[]{email});
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)bodyText);
        TextHelper.boldAllOccurencesOfText(spannableStringBuilder, bodyText, email);
        body.setText((CharSequence)spannableStringBuilder);
    }

    private void setOnClickListeners(View view, String email) {
        view.findViewById(R.id.trouble_signing_in).setOnClickListener(v -> this.mListener.onTroubleSigningIn(email));
    }

    private void setPrivacyFooter(View view) {
        TextView footerText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), this.getFlowParams(), footerText);
    }

    public void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        state.putBoolean(EMAIL_SENT, this.mEmailSent);
    }

    static interface TroubleSigningInListener {
        public void onTroubleSigningIn(String var1);

        public void onSendEmailFailure(Exception var1);
    }
}

