/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.ui.FragmentBase;
import com.google.android.material.progressindicator.CircularProgressIndicator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InvisibleFragmentBase
extends FragmentBase {
    private static final long MIN_SPINNER_MS = 750L;
    protected FrameLayout mFrameLayout;
    protected View mTopLevelView;
    private Handler mHandler = new Handler();
    private CircularProgressIndicator mProgressBar;
    private long mLastShownTime = 0L;

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mProgressBar = new CircularProgressIndicator((Context)new ContextThemeWrapper(this.getContext(), this.getFlowParams().themeId));
        this.mProgressBar.setIndeterminate(true);
        this.mProgressBar.setVisibility(8);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.mFrameLayout = (FrameLayout)view.findViewById(R.id.invisible_frame);
        this.mFrameLayout.addView((View)this.mProgressBar, (ViewGroup.LayoutParams)params);
    }

    @Override
    public void showProgress(int message) {
        if (this.mProgressBar.getVisibility() == 0) {
            this.mHandler.removeCallbacksAndMessages(null);
            return;
        }
        this.mLastShownTime = System.currentTimeMillis();
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.doAfterTimeout(() -> {
            this.mLastShownTime = 0L;
            this.mProgressBar.setVisibility(8);
            this.mFrameLayout.setVisibility(8);
        });
    }

    protected void doAfterTimeout(Runnable runnable) {
        long currentTime = System.currentTimeMillis();
        long diff = currentTime - this.mLastShownTime;
        long remaining = Math.max(750L - diff, 0L);
        this.mHandler.postDelayed(runnable, remaining);
    }
}

