/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.model;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class User
implements Parcelable {
    public static final Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>(){

        public User createFromParcel(Parcel in) {
            return new User(in.readString(), in.readString(), in.readString(), in.readString(), (Uri)in.readParcelable(Uri.class.getClassLoader()));
        }

        public User[] newArray(int size) {
            return new User[size];
        }
    };
    private final String mProviderId;
    private final String mEmail;
    private final String mPhoneNumber;
    private final String mName;
    private final Uri mPhotoUri;

    private User(String providerId, String email, String phoneNumber, String name, Uri photoUri) {
        this.mProviderId = providerId;
        this.mEmail = email;
        this.mPhoneNumber = phoneNumber;
        this.mName = name;
        this.mPhotoUri = photoUri;
    }

    public static User getUser(Intent intent) {
        return (User)intent.getParcelableExtra("extra_user");
    }

    public static User getUser(Bundle arguments) {
        return (User)arguments.getParcelable("extra_user");
    }

    @NonNull
    public String getProviderId() {
        return this.mProviderId;
    }

    @Nullable
    public String getEmail() {
        return this.mEmail;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.mPhoneNumber;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getPhotoUri() {
        return this.mPhotoUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.mProviderId.equals(user.mProviderId) && (this.mEmail == null ? user.mEmail == null : this.mEmail.equals(user.mEmail)) && (this.mPhoneNumber == null ? user.mPhoneNumber == null : this.mPhoneNumber.equals(user.mPhoneNumber)) && (this.mName == null ? user.mName == null : this.mName.equals(user.mName)) && (this.mPhotoUri == null ? user.mPhotoUri == null : this.mPhotoUri.equals((Object)user.mPhotoUri));
    }

    public int hashCode() {
        int result = this.mProviderId.hashCode();
        result = 31 * result + (this.mEmail == null ? 0 : this.mEmail.hashCode());
        result = 31 * result + (this.mPhoneNumber == null ? 0 : this.mPhoneNumber.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        result = 31 * result + (this.mPhotoUri == null ? 0 : this.mPhotoUri.hashCode());
        return result;
    }

    public String toString() {
        return "User{mProviderId='" + this.mProviderId + '\'' + ", mEmail='" + this.mEmail + '\'' + ", mPhoneNumber='" + this.mPhoneNumber + '\'' + ", mName='" + this.mName + '\'' + ", mPhotoUri=" + this.mPhotoUri + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mProviderId);
        dest.writeString(this.mEmail);
        dest.writeString(this.mPhoneNumber);
        dest.writeString(this.mName);
        dest.writeParcelable((Parcelable)this.mPhotoUri, flags);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Builder {
        private String mProviderId;
        private String mEmail;
        private String mPhoneNumber;
        private String mName;
        private Uri mPhotoUri;

        public Builder(@NonNull String providerId, @Nullable String email) {
            this.mProviderId = providerId;
            this.mEmail = email;
        }

        public Builder setPhoneNumber(String phoneNumber) {
            this.mPhoneNumber = phoneNumber;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setPhotoUri(Uri photoUri) {
            this.mPhotoUri = photoUri;
            return this;
        }

        public User build() {
            return new User(this.mProviderId, this.mEmail, this.mPhoneNumber, this.mName, this.mPhotoUri);
        }
    }
}

