/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import java.io.Serializable;
import java.text.Collator;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CountryInfo
implements Comparable<CountryInfo>,
Parcelable {
    public static final Parcelable.Creator<CountryInfo> CREATOR = new Parcelable.Creator<CountryInfo>(){

        public CountryInfo createFromParcel(Parcel source) {
            return new CountryInfo(source);
        }

        public CountryInfo[] newArray(int size) {
            return new CountryInfo[size];
        }
    };
    private final Collator mCollator = Collator.getInstance(Locale.getDefault());
    private final Locale mLocale;
    private final int mCountryCode;

    public CountryInfo(Locale locale, int countryCode) {
        this.mCollator.setStrength(0);
        this.mLocale = locale;
        this.mCountryCode = countryCode;
    }

    protected CountryInfo(Parcel in) {
        this.mCollator.setStrength(0);
        this.mLocale = (Locale)in.readSerializable();
        this.mCountryCode = in.readInt();
    }

    public static String localeToEmoji(Locale locale) {
        String countryCode = locale.getCountry();
        int firstLetter = Character.codePointAt(countryCode, 0) - 65 + 127462;
        int secondLetter = Character.codePointAt(countryCode, 1) - 65 + 127462;
        return new String(Character.toChars(firstLetter)) + new String(Character.toChars(secondLetter));
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getCountryCode() {
        return this.mCountryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryInfo that = (CountryInfo)o;
        return this.mCountryCode == that.mCountryCode && (this.mLocale != null ? this.mLocale.equals(that.mLocale) : that.mLocale == null);
    }

    public int hashCode() {
        int result = this.mLocale != null ? this.mLocale.hashCode() : 0;
        result = 31 * result + this.mCountryCode;
        return result;
    }

    public String toString() {
        return CountryInfo.localeToEmoji(this.mLocale) + " " + this.mLocale.getDisplayCountry() + " +" + this.mCountryCode;
    }

    public String toShortString() {
        return CountryInfo.localeToEmoji(this.mLocale) + " +" + this.mCountryCode;
    }

    @Override
    public int compareTo(CountryInfo info) {
        Locale defaultLocale = Locale.getDefault();
        return this.mCollator.compare(this.mLocale.getDisplayCountry().toUpperCase(defaultLocale), info.mLocale.getDisplayCountry().toUpperCase(defaultLocale));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.mLocale);
        dest.writeInt(this.mCountryCode);
    }
}

