/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.ErrorCodes;

public class FirebaseUiException
extends Exception {
    private final int mErrorCode;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FirebaseUiException(int code) {
        this(code, ErrorCodes.toFriendlyMessage(code));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FirebaseUiException(int code, @NonNull String message) {
        super(message);
        this.mErrorCode = code;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FirebaseUiException(int code, @NonNull Throwable cause) {
        this(code, ErrorCodes.toFriendlyMessage(code), cause);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FirebaseUiException(int code, @NonNull String message, @NonNull Throwable cause) {
        super(message, cause);
        this.mErrorCode = code;
    }

    public final int getErrorCode() {
        return this.mErrorCode;
    }
}

