/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.firebase.ui.auth.AuthUI;
import java.util.HashMap;
import java.util.Map;

public class AuthMethodPickerLayout
implements Parcelable {
    @LayoutRes
    private int mainLayout;
    @IdRes
    private int tosPpView = -1;
    private Map<String, Integer> providersButton;
    public static final Parcelable.Creator<AuthMethodPickerLayout> CREATOR = new Parcelable.Creator<AuthMethodPickerLayout>(){

        public AuthMethodPickerLayout createFromParcel(Parcel in) {
            return new AuthMethodPickerLayout(in);
        }

        public AuthMethodPickerLayout[] newArray(int size) {
            return new AuthMethodPickerLayout[size];
        }
    };

    private AuthMethodPickerLayout() {
    }

    private AuthMethodPickerLayout(@NonNull Parcel in) {
        this.mainLayout = in.readInt();
        this.tosPpView = in.readInt();
        Bundle buttonsBundle = in.readBundle(this.getClass().getClassLoader());
        this.providersButton = new HashMap<String, Integer>();
        for (String key : buttonsBundle.keySet()) {
            this.providersButton.put(key, buttonsBundle.getInt(key));
        }
    }

    @LayoutRes
    public int getMainLayout() {
        return this.mainLayout;
    }

    @IdRes
    public int getTosPpView() {
        return this.tosPpView;
    }

    public Map<String, Integer> getProvidersButton() {
        return this.providersButton;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mainLayout);
        parcel.writeInt(this.tosPpView);
        Bundle bundle = new Bundle();
        for (String key : this.providersButton.keySet()) {
            bundle.putInt(key, this.providersButton.get(key).intValue());
        }
        parcel.writeBundle(bundle);
    }

    public static class Builder {
        private Map<String, Integer> providersMapping;
        private AuthMethodPickerLayout instance = new AuthMethodPickerLayout();

        public Builder(@LayoutRes int mainLayout) {
            this.instance.mainLayout = mainLayout;
            this.providersMapping = new HashMap<String, Integer>();
        }

        public Builder setGoogleButtonId(@IdRes int googleBtn) {
            this.providersMapping.put("google.com", googleBtn);
            return this;
        }

        public Builder setFacebookButtonId(@IdRes int facebookBtn) {
            this.providersMapping.put("facebook.com", facebookBtn);
            return this;
        }

        public Builder setTwitterButtonId(@IdRes int twitterBtn) {
            this.providersMapping.put("twitter.com", twitterBtn);
            return this;
        }

        public Builder setEmailButtonId(@IdRes int emailButton) {
            this.providersMapping.put("password", emailButton);
            return this;
        }

        public Builder setPhoneButtonId(@IdRes int phoneButton) {
            this.providersMapping.put("phone", phoneButton);
            return this;
        }

        public Builder setAnonymousButtonId(@IdRes int anonymousButton) {
            this.providersMapping.put("anonymous", anonymousButton);
            return this;
        }

        public Builder setGithubButtonId(@IdRes int githubButtonId) {
            this.providersMapping.put("github.com", githubButtonId);
            return this;
        }

        public Builder setMicrosoftButtonId(@IdRes int microsoftButtonId) {
            this.providersMapping.put("microsoft.com", microsoftButtonId);
            return this;
        }

        public Builder setAppleButtonId(@IdRes int appleButtonId) {
            this.providersMapping.put("apple.com", appleButtonId);
            return this;
        }

        public Builder setYahooButtonId(@IdRes int yahooButtonId) {
            this.providersMapping.put("yahoo.com", yahooButtonId);
            return this;
        }

        public Builder setTosAndPrivacyPolicyId(@IdRes int tosPpView) {
            this.instance.tosPpView = tosPpView;
            return this;
        }

        public AuthMethodPickerLayout build() {
            if (this.providersMapping.isEmpty()) {
                throw new IllegalArgumentException("Must configure at least one button.");
            }
            for (String key : this.providersMapping.keySet()) {
                if (AuthUI.SUPPORTED_PROVIDERS.contains(key) || AuthUI.SUPPORTED_OAUTH_PROVIDERS.contains(key)) continue;
                throw new IllegalArgumentException("Unknown provider: " + key);
            }
            this.instance.providersButton = this.providersMapping;
            return this.instance;
        }
    }
}

