/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard_networking.encryption;

import com.fintecsystems.xs2awizard_networking.encryption.Encryptor;
import com.github.mervick.aes_everywhere.legacy.Aes256;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fintecsystems/xs2awizard_networking/encryption/Encryptor;", "", "modulus", "", "exponent", "(Ljava/lang/String;Ljava/lang/String;)V", "publicKey", "Ljava/security/PublicKey;", "(Ljava/security/PublicKey;)V", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "encodeMessage", "message", "Companion", "xs2awizard_networking_release"})
public final class Encryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicKey publicKey;
    private final Cipher cipher;
    @NotNull
    private static final List<Character> allowedChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));

    public Encryptor(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.publicKey = publicKey;
        this.cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
    }

    public Encryptor(@NotNull String modulus, @NotNull String exponent) {
        Intrinsics.checkNotNullParameter((Object)modulus, (String)"modulus");
        Intrinsics.checkNotNullParameter((Object)exponent, (String)"exponent");
        this(Encryptor.Companion.constructKey(modulus, exponent));
    }

    @NotNull
    public final String encodeMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String password = Encryptor.Companion.generateRandomPassword(32);
        String encryptedMessage = Aes256.encrypt((String)message, (String)password);
        Cipher cipher = this.cipher;
        boolean bl = false;
        boolean bl2 = false;
        Cipher it = cipher;
        boolean bl3 = false;
        it.init(1, this.publicKey);
        String string2 = password;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = it.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.let {\n            it.init(Cipher.ENCRYPT_MODE, publicKey)\n            it.doFinal(password.toByteArray())\n        }");
        String encryptedPassword2 = ArraysKt.joinToString$default((byte[])byArray2, (CharSequence)"", null, null, (int)0, null, (Function1)encodeMessage.encryptedPassword.2.INSTANCE, (int)30, null);
        return encryptedPassword2 + "::" + encryptedMessage;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fintecsystems/xs2awizard_networking/encryption/Encryptor$Companion;", "", "()V", "allowedChars", "", "", "constructKey", "Ljava/security/PublicKey;", "modulus", "", "exponent", "generateRandomPassword", "length", "", "xs2awizard_networking_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateRandomPassword(int length) {
            SecureRandom secureRandom = new SecureRandom();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder $this$generateRandomPassword_u24lambda_u2d1 = stringBuilder;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            n = 0;
            int n2 = length;
            while (n < n2) {
                int it = n++;
                boolean bl5 = false;
                $this$generateRandomPassword_u24lambda_u2d1.append(((Character)allowedChars.get(secureRandom.nextInt(allowedChars.size()))).charValue());
            }
            String string2 = $this$generateRandomPassword_u24lambda_u2d1.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(StringBuilder()) {\n                repeat(length) {\n                    append(allowedChars[secureRandom.nextInt(allowedChars.size)])\n                }\n\n                this.toString()\n            }");
            return string2;
        }

        private final PublicKey constructKey(String modulus, String exponent) {
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(exponent, 16));
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getInstance(\"RSA\").generatePublic(keySpec)");
            return publicKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

