/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.networking.encryption;

import androidx.compose.runtime.internal.StabilityInferred;
import com.github.mervick.aes_everywhere.legacy.Aes256;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\tJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/fintecsystems/xs2awizard/networking/encryption/Encryptor;", "", "publicKey", "Ljava/security/PublicKey;", "<init>", "(Ljava/security/PublicKey;)V", "modulus", "", "exponent", "(Ljava/lang/String;Ljava/lang/String;)V", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "encodeMessage", "message", "Companion", "xs2awizard"})
@StabilityInferred(parameters=0)
public final class Encryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicKey publicKey;
    private final Cipher cipher;
    public static final int $stable = 8;
    @NotNull
    private static final List<Character> allowedChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));

    public Encryptor(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.publicKey = publicKey;
        this.cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
    }

    public Encryptor(@NotNull String modulus, @NotNull String exponent) {
        Intrinsics.checkNotNullParameter((Object)modulus, (String)"modulus");
        Intrinsics.checkNotNullParameter((Object)exponent, (String)"exponent");
        this(Encryptor.Companion.constructKey(modulus, exponent));
    }

    @NotNull
    public final String encodeMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String password = Encryptor.Companion.generateRandomPassword(32);
        String encryptedMessage = Aes256.encrypt((String)message, (String)password);
        Cipher it = this.cipher;
        boolean bl = false;
        it.init(1, this.publicKey);
        byte[] byArray = password.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = it.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"let(...)");
        String encryptedPassword = ArraysKt.joinToString$default((byte[])byArray2, (CharSequence)"", null, null, (int)0, null, Encryptor::encodeMessage$lambda$1, (int)30, null);
        return encryptedPassword + "::" + encryptedMessage;
    }

    private static final CharSequence encodeMessage$lambda$1(byte it) {
        String string2 = "%02X";
        Object[] objectArray = new Object[]{it};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fintecsystems/xs2awizard/networking/encryption/Encryptor$Companion;", "", "<init>", "()V", "allowedChars", "", "", "generateRandomPassword", "", "length", "", "constructKey", "Ljava/security/PublicKey;", "modulus", "exponent", "xs2awizard"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateRandomPassword(int length) {
            SecureRandom secureRandom = new SecureRandom();
            StringBuilder $this$generateRandomPassword_u24lambda_u240 = new StringBuilder();
            boolean bl = false;
            int n = 0;
            while (n < length) {
                int it = n++;
                boolean bl2 = false;
                $this$generateRandomPassword_u24lambda_u240.append(((Character)allowedChars.get(secureRandom.nextInt(allowedChars.size()))).charValue());
            }
            String string2 = $this$generateRandomPassword_u24lambda_u240.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(...)");
            return string2;
        }

        private final PublicKey constructKey(String modulus, String exponent) {
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(exponent, 16));
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
            return publicKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

