/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.helper;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Base64;
import android.widget.Toast;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardLanguage;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J \u0010\r\u001a\u0004\u0018\u0001H\u000e\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u000f*\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\u0010J)\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0019\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/fintecsystems/xs2awizard/helper/Utils;", "", "<init>", "()V", "decodeBase64Image", "Landroidx/compose/ui/graphics/ImageBitmap;", "base64String", "", "setClipboardText", "", "context", "Landroid/content/Context;", "text", "getActivity", "T", "Landroid/app/Activity;", "(Landroid/content/Context;)Landroid/app/Activity;", "type", "Lkotlin/reflect/KClass;", "(Landroid/content/Context;Lkotlin/reflect/KClass;)Landroid/app/Activity;", "checkIfLanguageNeedsToBeChanged", "", "language", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardLanguage;", "targetLanguage", "isMarshmallow", "()Z", "xs2awizard"})
@StabilityInferred(parameters=1)
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    public static final int $stable;

    private Utils() {
    }

    @NotNull
    public final ImageBitmap decodeBase64Image(@NotNull String base64String) {
        Intrinsics.checkNotNullParameter((Object)base64String, (String)"base64String");
        String cleanImage = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)base64String, (String)"data:image/png;base64,", (String)"", (boolean)false, (int)4, null), (String)"data:image/jpeg;base64,", (String)"", (boolean)false, (int)4, null), (String)"data:image/gif;base64,", (String)"", (boolean)false, (int)4, null);
        byte[] imageDataBytes = Base64.decode((String)cleanImage, (int)0);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageDataBytes, (int)0, (int)imageDataBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(...)");
        return AndroidImageBitmap_androidKt.asImageBitmap((Bitmap)bitmap);
    }

    public final void setClipboardText(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = context.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)"Copied Text", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
        Toast.makeText((Context)context, (CharSequence)context.getString(R.string.link_copied), (int)0).show();
    }

    public final /* synthetic */ <T extends Activity> T getActivity(Context $this$getActivity) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivity, (String)"<this>");
        boolean $i$f$getActivity = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.getActivity($this$getActivity, Reflection.getOrCreateKotlinClass(Activity.class));
    }

    @Nullable
    public final <T extends Activity> T getActivity(@NotNull Context $this$getActivity, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (type.isInstance((Object)$this$getActivity)) {
            return (T)((Activity)KClasses.cast(type, (Object)$this$getActivity));
        }
        if ($this$getActivity instanceof ContextWrapper) {
            Context context = ((ContextWrapper)$this$getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getBaseContext(...)");
            return this.getActivity(context, type);
        }
        return null;
    }

    public final boolean checkIfLanguageNeedsToBeChanged(@Nullable XS2AWizardLanguage language, @Nullable XS2AWizardLanguage targetLanguage) {
        if (language != null) {
            XS2AWizardLanguage xS2AWizardLanguage = targetLanguage;
            if (xS2AWizardLanguage == null) {
                String string2 = Locale.getDefault().getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguage(...)");
                xS2AWizardLanguage = XS2AWizardLanguage.Companion.fromString$default(XS2AWizardLanguage.Companion, string2, null, 2, null);
            }
            XS2AWizardLanguage languageToCheck = xS2AWizardLanguage;
            return ArraysKt.contains((Object[])XS2AWizardLanguage.values(), (Object)((Object)languageToCheck)) && languageToCheck != language;
        }
        return false;
    }

    public static /* synthetic */ boolean checkIfLanguageNeedsToBeChanged$default(Utils utils, XS2AWizardLanguage xS2AWizardLanguage, XS2AWizardLanguage xS2AWizardLanguage2, int n, Object object) {
        if ((n & 2) != 0) {
            xS2AWizardLanguage2 = null;
        }
        return utils.checkIfLanguageNeedsToBeChanged(xS2AWizardLanguage, xS2AWizardLanguage2);
    }

    @ChecksSdkIntAtLeast(api=23)
    public final boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }
}

