/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.components;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.biometric.BiometricPrompt;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import com.android.volley.VolleyError;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardConfig;
import com.fintecsystems.xs2awizard.components.XS2AWizardError;
import com.fintecsystems.xs2awizard.components.XS2AWizardStep;
import com.fintecsystems.xs2awizard.components.XS2AWizardViewModel;
import com.fintecsystems.xs2awizard.form.CheckBoxLineData;
import com.fintecsystems.xs2awizard.form.CredentialFormLineData;
import com.fintecsystems.xs2awizard.form.FormLineData;
import com.fintecsystems.xs2awizard.form.FormResponse;
import com.fintecsystems.xs2awizard.form.MultiForm;
import com.fintecsystems.xs2awizard.form.MultiLineData;
import com.fintecsystems.xs2awizard.form.ValueFormLineData;
import com.fintecsystems.xs2awizard.helper.Crypto;
import com.fintecsystems.xs2awizard.helper.JSONFormatter;
import com.fintecsystems.xs2awizard.helper.MarkupParser;
import com.fintecsystems.xs2awizard.helper.Utils;
import com.fintecsystems.xs2awizard_networking.NetworkingInstance;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 L2\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001cH\u0002J\b\u0010)\u001a\u00020$H\u0003J\u0006\u0010*\u001a\u00020$J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00172\n\b\u0002\u0010.\u001a\u0004\u0018\u00010,J\u0006\u0010/\u001a\u00020$J\u001c\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\r2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001703J\b\u00104\u001a\u00020$H\u0002J\u0012\u00105\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\u0017H\u0002J\u0016\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u00062\u0006\u00101\u001a\u00020\rJ\u0006\u0010:\u001a\u00020$J\u000e\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020\u0017J\u0010\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020?H\u0002J\u0006\u0010@\u001a\u00020$J\u0016\u0010A\u001a\u00020$2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0003J\u0010\u0010B\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0006\u0010C\u001a\u00020$J\u000e\u0010C\u001a\u00020$2\u0006\u0010-\u001a\u00020\u0017J\u0018\u0010C\u001a\u00020$2\u0006\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u001fH\u0002J\u0018\u0010C\u001a\u00020$2\u0006\u0010D\u001a\u00020F2\b\b\u0002\u0010E\u001a\u00020\u001fJ\"\u0010G\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00172\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020$0IJ\b\u0010J\u001a\u00020$H\u0003J\b\u0010K\u001a\u00020$H\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u001f\u0010\u001e\u001a\u0010\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "config", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardConfig;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "currentBiometricPromp", "Landroidx/biometric/BiometricPrompt;", "<set-?>", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardStep;", "currentStep", "getCurrentStep", "()Lcom/fintecsystems/xs2awizard/components/XS2AWizardStep;", "currentWebViewUrl", "Landroidx/lifecycle/MutableLiveData;", "", "getCurrentWebViewUrl", "()Landroidx/lifecycle/MutableLiveData;", "form", "", "Lcom/fintecsystems/xs2awizard/form/FormLineData;", "getForm", "loadingIndicatorLock", "", "kotlin.jvm.PlatformType", "getLoadingIndicatorLock", "provider", "abort", "", "appendValueToJson", "jsonBuilder", "Lkotlinx/serialization/json/JsonObjectBuilder;", "formLineData", "autoFillCredentials", "closeWebView", "constructJsonBody", "Lkotlinx/serialization/json/JsonObject;", "action", "values", "goBack", "handleAnnotationClick", "activity", "annotation", "Landroidx/compose/ui/text/AnnotatedString$Range;", "initForm", "isProviderInStore", "onFormReceived", "jsonString", "onStart", "_config", "onStop", "openWebView", "url", "parseCallback", "response", "Lcom/fintecsystems/xs2awizard/form/FormResponse;", "restart", "storeCredentials", "storeProvider", "submitForm", "jsonBody", "showIndicator", "Lkotlinx/serialization/json/JsonElement;", "submitFormWithCallback", "onSuccess", "Lkotlin/Function1;", "tryToAutoFillCredentials", "tryToStoreCredentials", "Companion", "xs2awizard_release"})
@StabilityInferred(parameters=0)
public final class XS2AWizardViewModel
extends AndroidViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private XS2AWizardConfig config;
    @NotNull
    private final MutableLiveData<List<FormLineData>> form;
    @NotNull
    private final MutableLiveData<Boolean> loadingIndicatorLock;
    @NotNull
    private final MutableLiveData<String> currentWebViewUrl;
    @Nullable
    private XS2AWizardStep currentStep;
    @Nullable
    private String provider;
    @NotNull
    private WeakReference<Activity> currentActivity;
    @Nullable
    private BiometricPrompt currentBiometricPromp;
    public static final int $stable = 8;
    @NotNull
    private static final String rememberLoginName = "store_credentials";
    @NotNull
    private static final String sharedPreferencesFileName = "xs2a_credentials";
    @NotNull
    private static final String storedProvidersKey = "providers";
    @NotNull
    private static final String masterKeyAlias = "xs2a_credentials_master_key";

    public XS2AWizardViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.form = new MutableLiveData();
        this.loadingIndicatorLock = new MutableLiveData((Object)false);
        this.currentWebViewUrl = new MutableLiveData(null);
        this.currentActivity = new WeakReference<Object>(null);
    }

    @NotNull
    public final MutableLiveData<List<FormLineData>> getForm() {
        return this.form;
    }

    @NotNull
    public final MutableLiveData<Boolean> getLoadingIndicatorLock() {
        return this.loadingIndicatorLock;
    }

    @NotNull
    public final MutableLiveData<String> getCurrentWebViewUrl() {
        return this.currentWebViewUrl;
    }

    private final Context getContext() {
        Context context = this.getApplication().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplication<Application>().applicationContext");
        return context;
    }

    @Nullable
    public final XS2AWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public final void onStart(@NotNull XS2AWizardConfig _config, @NotNull Activity activity) {
        XS2AWizardConfig xS2AWizardConfig;
        XS2AWizardConfig xS2AWizardConfig2;
        Intrinsics.checkNotNullParameter((Object)_config, (String)"_config");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.config = _config;
        this.currentActivity = new WeakReference<Activity>(activity);
        Object object = NetworkingInstance.Companion.getInstance((Object)this.getContext());
        NetworkingInstance $this$onStart_u24lambda_u2d0 = (NetworkingInstance)object;
        boolean bl = false;
        XS2AWizardConfig xS2AWizardConfig3 = this.config;
        if (xS2AWizardConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            xS2AWizardConfig2 = null;
        } else {
            xS2AWizardConfig2 = xS2AWizardConfig3;
        }
        $this$onStart_u24lambda_u2d0.setSessionKey(xS2AWizardConfig2.getSessionKey());
        xS2AWizardConfig3 = this.config;
        if (xS2AWizardConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            xS2AWizardConfig = null;
        } else {
            xS2AWizardConfig = xS2AWizardConfig3;
        }
        $this$onStart_u24lambda_u2d0.setBackendURL(xS2AWizardConfig.getBackendURL());
        this.initForm();
    }

    public final void onStop() {
        this.loadingIndicatorLock.setValue((Object)false);
        this.currentWebViewUrl.setValue(null);
        this.form.setValue((Object)CollectionsKt.emptyList());
        this.currentStep = null;
        this.currentActivity = new WeakReference<Object>(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void initForm() {
        void $this$initForm_u24lambda_u2d1;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$initForm_u24lambda_u2d1.put("version", (JsonElement)JsonElementKt.JsonPrimitive((String)"3.3.0"));
        $this$initForm_u24lambda_u2d1.put("client", (JsonElement)JsonElementKt.JsonPrimitive((String)this.getContext().getString(R.string.xs2a_client_tag)));
        Unit unit = Unit.INSTANCE;
        xS2AWizardViewModel.submitForm((JsonElement)builder$iv.build(), true);
    }

    /*
     * WARNING - void declaration
     */
    public final void goBack() {
        void $this$goBack_u24lambda_u2d2;
        JsonObjectBuilder builder$iv;
        XS2AWizardConfig xS2AWizardConfig;
        XS2AWizardConfig xS2AWizardConfig2 = this.config;
        if (xS2AWizardConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            xS2AWizardConfig = null;
        } else {
            xS2AWizardConfig = xS2AWizardConfig2;
        }
        xS2AWizardConfig.getOnBack().invoke();
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$goBack_u24lambda_u2d2.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"back"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void abort() {
        void $this$abort_u24lambda_u2d3;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$abort_u24lambda_u2d3.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"abort"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void restart() {
        void $this$restart_u24lambda_u2d4;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$restart_u24lambda_u2d4.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"restart"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    @NotNull
    public final JsonObject constructJsonBody(@NotNull String action, @Nullable JsonObject values) {
        Set set;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder $this$constructJsonBody_u24lambda_u2d7 = builder$iv = new JsonObjectBuilder();
        boolean bl2 = false;
        List list = (List)this.getForm().getValue();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormLineData it = (FormLineData)element$iv;
                boolean bl3 = false;
                this.appendValueToJson($this$constructJsonBody_u24lambda_u2d7, it);
            }
        }
        $this$constructJsonBody_u24lambda_u2d7.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)action));
        list = values;
        if (list != null && (set = list.entrySet()) != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                $this$constructJsonBody_u24lambda_u2d7.put((String)it.getKey(), (JsonElement)it.getValue());
            }
        }
        return builder$iv.build();
    }

    public static /* synthetic */ JsonObject constructJsonBody$default(XS2AWizardViewModel xS2AWizardViewModel, String string, JsonObject jsonObject, int n, Object object) {
        if ((n & 2) != 0) {
            jsonObject = null;
        }
        return xS2AWizardViewModel.constructJsonBody(string, jsonObject);
    }

    private final void appendValueToJson(JsonObjectBuilder jsonBuilder, FormLineData formLineData) {
        FormLineData formLineData2 = formLineData;
        if (formLineData2 instanceof ValueFormLineData) {
            JsonElement jsonElement;
            jsonBuilder.put(((ValueFormLineData)formLineData).getName(), (jsonElement = ((ValueFormLineData)formLineData).getValue()) == null ? (JsonElement)JsonNull.INSTANCE : jsonElement);
        } else if (formLineData2 instanceof MultiLineData) {
            Object v0;
            Object it;
            List<FormLineData> list;
            block6: {
                JsonElementBuildersKt.put((JsonObjectBuilder)jsonBuilder, (String)((MultiLineData)formLineData).getName(), (String)((MultiLineData)formLineData).getSelected());
                List<FormLineData> list2 = list = (List<FormLineData>)((MultiLineData)formLineData).getForms();
                boolean bl = false;
                for (Object t : list2) {
                    it = (MultiForm)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((MultiForm)it).getValue(), (Object)((MultiLineData)formLineData).getSelected())) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            MultiForm multiForm = v0;
            if (multiForm != null && (list = multiForm.getForm()) != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    it = (FormLineData)t;
                    boolean bl = false;
                    this.appendValueToJson(jsonBuilder, (FormLineData)it);
                }
            }
        }
    }

    public final void submitForm() {
        this.submitForm("submit");
    }

    public final void submitForm(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.submitForm((JsonElement)XS2AWizardViewModel.constructJsonBody$default(this, action, null, 2, null), true);
    }

    public final void submitForm(@NotNull JsonElement jsonBody, boolean showIndicator) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.submitForm(jsonBody.toString(), showIndicator);
    }

    public static /* synthetic */ void submitForm$default(XS2AWizardViewModel xS2AWizardViewModel, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        xS2AWizardViewModel.submitForm(jsonElement, bl);
    }

    private final void submitForm(String jsonBody, boolean showIndicator) {
        Object object;
        Object object2;
        if (showIndicator) {
            this.loadingIndicatorLock.setValue((Object)true);
        }
        if ((object2 = this.currentBiometricPromp) != null) {
            object2.cancelAuthentication();
        }
        object2 = this.config;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            object = null;
        } else {
            object = object2;
        }
        if (((XS2AWizardConfig)object).getEnableCredentialsStore() && Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToStoreCredentials();
        }
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(jsonBody, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                XS2AWizardViewModel.access$onFormReceived((XS2AWizardViewModel)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                XS2AWizardConfig xS2AWizardConfig;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardConfig xS2AWizardConfig2 = XS2AWizardViewModel.access$getConfig$p(this.this$0);
                if (xS2AWizardConfig2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    xS2AWizardConfig = null;
                } else {
                    xS2AWizardConfig = xS2AWizardConfig2;
                }
                xS2AWizardConfig.getOnNetworkError().invoke();
            }
        });
    }

    public final void submitFormWithCallback(@NotNull String action, @NotNull Function1<? super String, Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(XS2AWizardViewModel.constructJsonBody$default(this, action, null, 2, null).toString(), onSuccess, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                XS2AWizardConfig xS2AWizardConfig;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardConfig xS2AWizardConfig2 = XS2AWizardViewModel.access$getConfig$p(this.this$0);
                if (xS2AWizardConfig2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    xS2AWizardConfig = null;
                } else {
                    xS2AWizardConfig = xS2AWizardConfig2;
                }
                xS2AWizardConfig.getOnNetworkError().invoke();
            }
        });
    }

    public final void handleAnnotationClick(@NotNull Activity activity, @NotNull AnnotatedString.Range<String> annotation) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        String string2 = annotation.getTag();
        if (Intrinsics.areEqual((Object)string2, (Object)"autosubmit")) {
            JsonObject jsonBody = MarkupParser.INSTANCE.parseAutoSubmitPayloadAsJson((String)annotation.getItem());
            XS2AWizardViewModel.submitForm$default(this, (JsonElement)this.constructJsonBody("autosubmit", jsonBody), false, 2, null);
        } else {
            new CustomTabsIntent.Builder().build().launchUrl((Context)activity, Uri.parse((String)((String)annotation.getItem())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onFormReceived(String jsonString) {
        XS2AWizardConfig xS2AWizardConfig;
        StringFormat $this$decodeFromString$iv = (StringFormat)JSONFormatter.INSTANCE.getFormatter();
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(FormResponse.class));
        boolean $i$f$cast = false;
        FormResponse formResponse = (FormResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonString);
        if (Utils.INSTANCE.checkIfLanguageNeedsToBeChanged(formResponse.getLanguage())) {
            void $this$onFormReceived_u24lambda_u2d10;
            boolean $i$f$buildJsonObject = false;
            $i$f$decodeFromString = false;
            JsonObjectBuilder builder$iv = new JsonObjectBuilder();
            $this$serializer$iv$iv = builder$iv;
            XS2AWizardViewModel xS2AWizardViewModel = this;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2d10, (String)"action", (String)"change-language");
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2d10, (String)"language", (String)Locale.getDefault().getLanguage());
            Unit unit = Unit.INSTANCE;
            XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
            return;
        }
        this.parseCallback(formResponse);
        this.form.setValue(formResponse.getForm());
        XS2AWizardConfig xS2AWizardConfig2 = this.config;
        if (xS2AWizardConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            xS2AWizardConfig = null;
        } else {
            xS2AWizardConfig = xS2AWizardConfig2;
        }
        if (xS2AWizardConfig.getEnableCredentialsStore() && Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToAutoFillCredentials();
        }
        this.loadingIndicatorLock.setValue((Object)false);
    }

    private final boolean isProviderInStore(String provider) {
        Set set = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0).getStringSet(storedProvidersKey, null);
        return set == null ? false : set.contains(provider);
    }

    private final void storeProvider(String provider) {
        Set set;
        SharedPreferences sharedPreferences;
        SharedPreferences $this$storeProvider_u24lambda_u2d12 = sharedPreferences = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0);
        boolean bl = false;
        Set it = set = $this$storeProvider_u24lambda_u2d12.getStringSet(storedProvidersKey, null);
        boolean bl2 = false;
        Set providers = new LinkedHashSet();
        if (it != null) {
            providers.addAll(providers);
        }
        providers.add(provider);
        $this$storeProvider_u24lambda_u2d12.edit().putStringSet(storedProvidersKey, providers).apply();
    }

    @RequiresApi(value=23)
    private final void tryToStoreCredentials() {
        JsonElement jsonElement;
        Object v1;
        JsonPrimitive jsonPrimitive;
        Object $this$firstOrNull$iv;
        block4: {
            CharSequence charSequence;
            if (this.form.getValue() == null || (charSequence = (CharSequence)this.provider) == null || charSequence.length() == 0) {
                return;
            }
            Object object = this.form.getValue();
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"form.value!!");
            $this$firstOrNull$iv = (Iterable)object2;
            boolean $i$f$firstOrNull = false;
            jsonPrimitive = $this$firstOrNull$iv.iterator();
            while (jsonPrimitive.hasNext()) {
                Object element$iv = jsonPrimitive.next();
                FormLineData it = (FormLineData)element$iv;
                boolean bl = false;
                if (!(it instanceof CheckBoxLineData && Intrinsics.areEqual((Object)((CheckBoxLineData)it).getName(), (Object)rememberLoginName))) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        CheckBoxLineData consentCheckBoxLineData = v1;
        $this$firstOrNull$iv = consentCheckBoxLineData;
        if (!($this$firstOrNull$iv == null ? false : ((jsonElement = ((CheckBoxLineData)$this$firstOrNull$iv).getValue()) == null ? false : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? false : JsonElementKt.getBoolean((JsonPrimitive)jsonPrimitive))))) {
            return;
        }
        Object object = this.form.getValue();
        Intrinsics.checkNotNull((Object)object);
        Object object3 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"form.value!!");
        List formCopy = (List)object3;
        object3 = this.currentActivity.get();
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        }
        FragmentActivity fragmentActivity = (FragmentActivity)object3;
        object3 = this.getContext().getString(R.string.save_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.getString(R.stri\u2026credentials_prompt_title)");
        Object object4 = object3;
        object3 = this.getContext().getString(R.string.save_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.getString(R.stri\u2026tials_prompt_description)");
        Object object5 = object3;
        object3 = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.getString(R.string.cancel)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, (String)object4, (String)object5, (String)object3, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)new Function1<BiometricPrompt.AuthenticationResult, Unit>(this, (List<? extends FormLineData>)formCopy){
            final /* synthetic */ XS2AWizardViewModel this$0;
            final /* synthetic */ List<FormLineData> $formCopy;
            {
                this.this$0 = $receiver;
                this.$formCopy = $formCopy;
                super(1);
            }

            public final void invoke(@NotNull BiometricPrompt.AuthenticationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Log.d((String)"XS2AWizard", (String)("onAuthenticationSucceeded: " + it.getAuthenticationType()));
                XS2AWizardViewModel.access$storeCredentials(this.this$0, this.$formCopy);
            }
        }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)tryToStoreCredentials.2.INSTANCE));
    }

    @RequiresApi(value=23)
    private final void storeCredentials(List<? extends FormLineData> form) {
        SharedPreferences.Editor editor;
        String string2 = this.provider;
        Intrinsics.checkNotNull((Object)string2);
        this.storeProvider(string2);
        SharedPreferences.Editor $this$storeCredentials_u24lambda_u2d15 = editor = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, Crypto.INSTANCE.createMasterKey(this.getContext(), masterKeyAlias)).edit();
        boolean bl = false;
        Iterable $this$forEach$iv = form;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string3;
            JsonPrimitive jsonPrimitive;
            JsonElement jsonElement;
            FormLineData it = (FormLineData)element$iv;
            boolean bl2 = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            if (it instanceof CheckBoxLineData) {
                boolean bl3;
                CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
                String string4 = this.provider;
                Intrinsics.checkNotNull((Object)string4);
                jsonElement = ((CredentialFormLineData)it).getValue();
                $this$storeCredentials_u24lambda_u2d15.putBoolean(credentialFormLineData.getProviderName(string4), jsonElement == null ? false : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? false : (bl3 = JsonElementKt.getBoolean((JsonPrimitive)jsonPrimitive))));
                continue;
            }
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string5 = this.provider;
            Intrinsics.checkNotNull((Object)string5);
            jsonElement = ((CredentialFormLineData)it).getValue();
            $this$storeCredentials_u24lambda_u2d15.putString(credentialFormLineData.getProviderName(string5), jsonElement == null ? "" : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? "" : ((string3 = jsonPrimitive.getContent()) == null ? "" : string3)));
        }
        $this$storeCredentials_u24lambda_u2d15.apply();
    }

    @RequiresApi(value=23)
    private final void tryToAutoFillCredentials() {
        Object object;
        block13: {
            block12: {
                boolean bl;
                if (this.form.getValue() == null) break block12;
                object = (List)this.form.getValue();
                if (object == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    block11: {
                        Iterable $this$none$iv = (Iterable)object;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                FormLineData it = (FormLineData)element$iv;
                                boolean bl3 = false;
                                if (!(it instanceof CredentialFormLineData && Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true))) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                    }
                    bl = bl2;
                }
                if (!bl) break block13;
            }
            return;
        }
        object = this.provider;
        if (object == null || object.length() == 0 || !this.isProviderInStore(this.provider)) {
            return;
        }
        object = this.currentActivity.get();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        }
        FragmentActivity fragmentActivity = (FragmentActivity)object;
        object = this.getContext().getString(R.string.fill_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(R.stri\u2026credentials_prompt_title)");
        Object object2 = object;
        object = this.getContext().getString(R.string.fill_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(R.stri\u2026tials_prompt_description)");
        Object object3 = object;
        object = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(R.string.cancel)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, (String)object2, (String)object3, (String)object, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)new Function1<BiometricPrompt.AuthenticationResult, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BiometricPrompt.AuthenticationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Log.d((String)"XS2AWizard", (String)("onAuthenticationSucceeded: " + it.getAuthenticationType()));
                XS2AWizardViewModel.access$autoFillCredentials(this.this$0);
            }
        }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)tryToAutoFillCredentials.3.INSTANCE));
    }

    @RequiresApi(value=23)
    private final void autoFillCredentials() {
        SharedPreferences sharedPreferences = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, Crypto.INSTANCE.createMasterKey(this.getContext(), masterKeyAlias));
        Object object = this.form.getValue();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"form.value!!");
        Iterable $this$forEach$iv = (Iterable)object2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FormLineData it = (FormLineData)element$iv;
            boolean bl = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string2 = this.provider;
            Intrinsics.checkNotNull((Object)string2);
            String key = credentialFormLineData.getProviderName(string2);
            if (it instanceof CheckBoxLineData) {
                if (!sharedPreferences.contains(key)) continue;
                ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((Boolean)sharedPreferences.getBoolean(key, false)));
                continue;
            }
            if (!sharedPreferences.contains(key)) continue;
            ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((String)sharedPreferences.getString(key, "")));
        }
        this.submitForm();
    }

    private final void parseCallback(FormResponse response) {
        Object object;
        Object object2;
        Object object3 = response.getCallback();
        if (Intrinsics.areEqual((Object)object3, (Object)"finish")) {
            JsonElement jsonElement;
            XS2AWizardConfig xS2AWizardConfig;
            object2 = this.config;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                xS2AWizardConfig = null;
            } else {
                xS2AWizardConfig = object2;
            }
            object2 = response.getCallbackParams();
            xS2AWizardConfig.getOnFinish().invoke(object2 == null ? null : ((jsonElement = (JsonElement)CollectionsKt.getOrNull((List)object2, (int)0)) == null ? null : ((object = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? null : object.getContent())));
        } else if (Intrinsics.areEqual((Object)object3, (Object)"abort")) {
            Object object4;
            object2 = this.config;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                object4 = null;
            } else {
                object4 = object2;
            }
            ((XS2AWizardConfig)object4).getOnAbort().invoke();
        } else {
            this.currentStep = XS2AWizardStep.Companion.getRelevantStep(response.getCallback());
            if (this.currentStep != null) {
                Object object5;
                object2 = this.config;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    object5 = null;
                } else {
                    object5 = object2;
                }
                Function1<XS2AWizardStep, Unit> function1 = ((XS2AWizardConfig)object5).getOnStep();
                XS2AWizardStep xS2AWizardStep = this.currentStep;
                Intrinsics.checkNotNull((Object)xS2AWizardStep);
                function1.invoke((Object)xS2AWizardStep);
            }
        }
        object3 = response.getCallbackParams();
        Object it = object3 = object3 == null ? null : (JsonElement)CollectionsKt.first((List)object3);
        boolean bl = false;
        if (it instanceof JsonObject && ((JsonObject)it).containsKey((Object)"provider")) {
            object = ((JsonObject)it).get((Object)"provider");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            }
            this.provider = object.getContent();
        }
        if (response.getError() != null) {
            Object object6;
            object3 = this.config;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                object6 = null;
            } else {
                object6 = object3;
            }
            object3 = response.isErrorRecoverable();
            ((XS2AWizardConfig)object6).getOnError().invoke((Object)XS2AWizardError.Companion.getRelevantError(response.getError(), object3 == null ? false : (Boolean)object3));
        }
    }

    public final void openWebView(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.currentWebViewUrl.setValue((Object)url);
    }

    public final void closeWebView() {
        this.currentWebViewUrl.setValue(null);
    }

    public static final /* synthetic */ void access$onFormReceived(XS2AWizardViewModel $this, String jsonString) {
        $this.onFormReceived(jsonString);
    }

    public static final /* synthetic */ XS2AWizardConfig access$getConfig$p(XS2AWizardViewModel $this) {
        return $this.config;
    }

    public static final /* synthetic */ void access$storeCredentials(XS2AWizardViewModel $this, List form) {
        $this.storeCredentials(form);
    }

    public static final /* synthetic */ void access$autoFillCredentials(XS2AWizardViewModel $this) {
        $this.autoFillCredentials();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$Companion;", "", "()V", "masterKeyAlias", "", "rememberLoginName", "sharedPreferencesFileName", "storedProvidersKey", "clearCredentials", "", "context", "Landroid/content/Context;", "xs2awizard_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCredentials(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSharedPreferences(XS2AWizardViewModel.sharedPreferencesFileName, 0).edit();
            SharedPreferences.Editor $this$clearCredentials_u24lambda_u2d0 = object;
            boolean bl = false;
            $this$clearCredentials_u24lambda_u2d0.clear();
            $this$clearCredentials_u24lambda_u2d0.apply();
            Object $this$clearCredentials_u24lambda_u2d1 = object = KeyStore.getInstance("AndroidKeyStore");
            boolean bl2 = false;
            ((KeyStore)$this$clearCredentials_u24lambda_u2d1).load(null);
            ((KeyStore)$this$clearCredentials_u24lambda_u2d1).deleteEntry(XS2AWizardViewModel.masterKeyAlias);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

