/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.helper;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import com.fintecsystems.xs2awizard.R;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/fintecsystems/xs2awizard/helper/Utils;", "", "()V", "languageWhitelist", "", "", "checkIfLanguageNeedsToBeChanged", "", "language", "decodeBase64Image", "Landroidx/compose/ui/graphics/ImageBitmap;", "base64String", "setClipboardText", "", "context", "Landroid/content/Context;", "text", "getActivity", "Landroidx/appcompat/app/AppCompatActivity;", "xs2awizard_release"})
@StabilityInferred(parameters=0)
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final List<String> languageWhitelist;
    public static final int $stable;

    private Utils() {
    }

    @NotNull
    public final ImageBitmap decodeBase64Image(@NotNull String base64String) {
        Intrinsics.checkNotNullParameter((Object)base64String, (String)"base64String");
        String cleanImage = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)base64String, (String)"data:image/png;base64,", (String)"", (boolean)false, (int)4, null), (String)"data:image/jpeg;base64,", (String)"", (boolean)false, (int)4, null), (String)"data:image/gif;base64,", (String)"", (boolean)false, (int)4, null);
        byte[] imageDataBytes = Base64.decode((String)cleanImage, (int)0);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageDataBytes, (int)0, (int)imageDataBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(imageDat\u2026, 0, imageDataBytes.size)");
        return AndroidImageBitmap_androidKt.asImageBitmap((Bitmap)bitmap);
    }

    public final void setClipboardText(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)"Copied Text", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
        Toast.makeText((Context)context, (CharSequence)context.getString(R.string.link_copied), (int)0).show();
    }

    @Nullable
    public final AppCompatActivity getActivity(@NotNull Context $this$getActivity) {
        AppCompatActivity appCompatActivity;
        Intrinsics.checkNotNullParameter((Object)$this$getActivity, (String)"<this>");
        Context context = $this$getActivity;
        if (context instanceof AppCompatActivity) {
            appCompatActivity = (AppCompatActivity)$this$getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"baseContext");
            appCompatActivity = this.getActivity(context2);
        } else {
            appCompatActivity = null;
        }
        return appCompatActivity;
    }

    public final boolean checkIfLanguageNeedsToBeChanged(@Nullable String language) {
        if (language != null) {
            String deviceLanguage = Locale.getDefault().getLanguage();
            String formLanguage = new Locale(language).getLanguage();
            return languageWhitelist.contains(deviceLanguage) && !deviceLanguage.equals(formLanguage);
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"de", "en", "fr", "it", "es"};
        languageWhitelist = CollectionsKt.listOf((Object[])objectArray);
        $stable = 8;
    }
}

