/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.components;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import com.android.volley.VolleyError;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardConfig;
import com.fintecsystems.xs2awizard.components.XS2AWizardError;
import com.fintecsystems.xs2awizard.form.FormLineData;
import com.fintecsystems.xs2awizard.form.FormResponse;
import com.fintecsystems.xs2awizard.form.MultiForm;
import com.fintecsystems.xs2awizard.form.MultiLineData;
import com.fintecsystems.xs2awizard.form.ValueFormLineData;
import com.fintecsystems.xs2awizard.helper.JSONFormatter;
import com.fintecsystems.xs2awizard.helper.MarkupParser;
import com.fintecsystems.xs2awizard.helper.Utils;
import com.fintecsystems.xs2awizard_networking.NetworkingInstance;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010 J\u0006\u0010#\u001a\u00020\u0019J\u001c\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(J\b\u0010)\u001a\u00020\u0019H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\rH\u0002J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0006J\u0006\u0010.\u001a\u00020\u0019J\u000e\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\rJ\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203H\u0002J\u0006\u00104\u001a\u00020\u0019J\u0006\u00105\u001a\u00020\u0019J\u000e\u00105\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\rJ\u0018\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\u0015H\u0002J\u0018\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u0002082\b\b\u0002\u00107\u001a\u00020\u0015J\"\u00109\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\r2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190;R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001f\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006<"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "config", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardConfig;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "currentWebViewUrl", "Landroidx/lifecycle/MutableLiveData;", "", "getCurrentWebViewUrl", "()Landroidx/lifecycle/MutableLiveData;", "form", "", "Lcom/fintecsystems/xs2awizard/form/FormLineData;", "getForm", "loadingIndicatorLock", "", "kotlin.jvm.PlatformType", "getLoadingIndicatorLock", "abort", "", "appendValueToJson", "jsonBuilder", "Lkotlinx/serialization/json/JsonObjectBuilder;", "formLineData", "closeWebView", "constructJsonBody", "Lkotlinx/serialization/json/JsonObject;", "action", "values", "goBack", "handleAnnotationClick", "activity", "Landroid/app/Activity;", "annotation", "Landroidx/compose/ui/text/AnnotatedString$Range;", "initForm", "onFormReceived", "jsonString", "onStart", "_config", "onStop", "openWebView", "url", "parseCallback", "response", "Lcom/fintecsystems/xs2awizard/form/FormResponse;", "restart", "submitForm", "jsonBody", "showIndicator", "Lkotlinx/serialization/json/JsonElement;", "submitFormWithCallback", "onSuccess", "Lkotlin/Function1;", "xs2awizard_release"})
@StabilityInferred(parameters=0)
public final class XS2AWizardViewModel
extends AndroidViewModel {
    private XS2AWizardConfig config;
    @NotNull
    private final MutableLiveData<List<FormLineData>> form;
    @NotNull
    private final MutableLiveData<Boolean> loadingIndicatorLock;
    @NotNull
    private final MutableLiveData<String> currentWebViewUrl;
    public static final int $stable = 8;

    public XS2AWizardViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.form = new MutableLiveData();
        this.loadingIndicatorLock = new MutableLiveData((Object)false);
        this.currentWebViewUrl = new MutableLiveData(null);
    }

    @NotNull
    public final MutableLiveData<List<FormLineData>> getForm() {
        return this.form;
    }

    @NotNull
    public final MutableLiveData<Boolean> getLoadingIndicatorLock() {
        return this.loadingIndicatorLock;
    }

    @NotNull
    public final MutableLiveData<String> getCurrentWebViewUrl() {
        return this.currentWebViewUrl;
    }

    private final Context getContext() {
        Context context = this.getApplication().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplication<Application>().applicationContext");
        return context;
    }

    public final void onStart(@NotNull XS2AWizardConfig _config) {
        XS2AWizardConfig xS2AWizardConfig;
        XS2AWizardConfig xS2AWizardConfig2;
        Intrinsics.checkNotNullParameter((Object)_config, (String)"_config");
        this.config = _config;
        Object object = NetworkingInstance.Companion.getInstance((Object)this.getContext());
        NetworkingInstance $this$onStart_u24lambda_u2d0 = (NetworkingInstance)object;
        boolean bl = false;
        XS2AWizardConfig xS2AWizardConfig3 = this.config;
        if (xS2AWizardConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            xS2AWizardConfig2 = null;
        } else {
            xS2AWizardConfig2 = xS2AWizardConfig3;
        }
        $this$onStart_u24lambda_u2d0.setSessionKey(xS2AWizardConfig2.getSessionKey());
        xS2AWizardConfig3 = this.config;
        if (xS2AWizardConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            xS2AWizardConfig = null;
        } else {
            xS2AWizardConfig = xS2AWizardConfig3;
        }
        $this$onStart_u24lambda_u2d0.setBackendURL(xS2AWizardConfig.getBackendURL());
        this.initForm();
    }

    public final void onStop() {
        this.loadingIndicatorLock.setValue((Object)false);
        this.currentWebViewUrl.setValue(null);
        this.form.setValue((Object)CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final void initForm() {
        void $this$initForm_u24lambda_u2d1;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$initForm_u24lambda_u2d1.put("version", (JsonElement)JsonElementKt.JsonPrimitive((String)"3.0.0"));
        $this$initForm_u24lambda_u2d1.put("client", (JsonElement)JsonElementKt.JsonPrimitive((String)this.getContext().getString(R.string.xs2a_client_tag)));
        Unit unit = Unit.INSTANCE;
        xS2AWizardViewModel.submitForm((JsonElement)builder$iv.build(), true);
    }

    /*
     * WARNING - void declaration
     */
    public final void goBack() {
        void $this$goBack_u24lambda_u2d2;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$goBack_u24lambda_u2d2.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"back"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void abort() {
        void $this$abort_u24lambda_u2d3;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$abort_u24lambda_u2d3.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"abort"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void restart() {
        void $this$restart_u24lambda_u2d4;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl2 = false;
        $this$restart_u24lambda_u2d4.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"restart"));
        Unit unit = Unit.INSTANCE;
        XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    @NotNull
    public final JsonObject constructJsonBody(@NotNull String action, @Nullable JsonObject values) {
        Set set;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        boolean $i$f$buildJsonObject = false;
        boolean bl = false;
        JsonObjectBuilder $this$constructJsonBody_u24lambda_u2d7 = builder$iv = new JsonObjectBuilder();
        boolean bl2 = false;
        List list = (List)this.getForm().getValue();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormLineData it = (FormLineData)element$iv;
                boolean bl3 = false;
                this.appendValueToJson($this$constructJsonBody_u24lambda_u2d7, it);
            }
        }
        $this$constructJsonBody_u24lambda_u2d7.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)action));
        list = values;
        if (list != null && (set = list.entrySet()) != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                $this$constructJsonBody_u24lambda_u2d7.put((String)it.getKey(), (JsonElement)it.getValue());
            }
        }
        return builder$iv.build();
    }

    public static /* synthetic */ JsonObject constructJsonBody$default(XS2AWizardViewModel xS2AWizardViewModel, String string, JsonObject jsonObject, int n, Object object) {
        if ((n & 2) != 0) {
            jsonObject = null;
        }
        return xS2AWizardViewModel.constructJsonBody(string, jsonObject);
    }

    private final void appendValueToJson(JsonObjectBuilder jsonBuilder, FormLineData formLineData) {
        FormLineData formLineData2 = formLineData;
        if (formLineData2 instanceof ValueFormLineData) {
            JsonElement jsonElement;
            jsonBuilder.put(((ValueFormLineData)formLineData).getName(), (jsonElement = ((ValueFormLineData)formLineData).getValue()) == null ? (JsonElement)JsonNull.INSTANCE : jsonElement);
        } else if (formLineData2 instanceof MultiLineData) {
            Object v0;
            Object it;
            List<FormLineData> list;
            block6: {
                JsonElementBuildersKt.put((JsonObjectBuilder)jsonBuilder, (String)((MultiLineData)formLineData).getName(), (String)((MultiLineData)formLineData).getSelected());
                List<FormLineData> list2 = list = (List<FormLineData>)((MultiLineData)formLineData).getForms();
                boolean bl = false;
                for (Object t : list2) {
                    it = (MultiForm)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((MultiForm)it).getValue(), (Object)((MultiLineData)formLineData).getSelected())) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            MultiForm multiForm = v0;
            if (multiForm != null && (list = multiForm.getForm()) != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    it = (FormLineData)t;
                    boolean bl = false;
                    this.appendValueToJson(jsonBuilder, (FormLineData)it);
                }
            }
        }
    }

    public final void submitForm() {
        this.submitForm("submit");
    }

    public final void submitForm(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.submitForm((JsonElement)XS2AWizardViewModel.constructJsonBody$default(this, action, null, 2, null), true);
    }

    public final void submitForm(@NotNull JsonElement jsonBody, boolean showIndicator) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.submitForm(jsonBody.toString(), showIndicator);
    }

    public static /* synthetic */ void submitForm$default(XS2AWizardViewModel xS2AWizardViewModel, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        xS2AWizardViewModel.submitForm(jsonElement, bl);
    }

    private final void submitForm(String jsonBody, boolean showIndicator) {
        if (showIndicator) {
            this.loadingIndicatorLock.setValue((Object)true);
        }
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(jsonBody, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                XS2AWizardViewModel.access$onFormReceived((XS2AWizardViewModel)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                XS2AWizardConfig xS2AWizardConfig;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardConfig xS2AWizardConfig2 = XS2AWizardViewModel.access$getConfig$p(this.this$0);
                if (xS2AWizardConfig2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    xS2AWizardConfig = null;
                } else {
                    xS2AWizardConfig = xS2AWizardConfig2;
                }
                xS2AWizardConfig.getOnNetworkError().invoke();
            }
        });
    }

    public final void submitFormWithCallback(@NotNull String action, @NotNull Function1<? super String, Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        ((NetworkingInstance)NetworkingInstance.Companion.getInstance((Object)this.getContext())).encodeAndSendMessage(XS2AWizardViewModel.constructJsonBody$default(this, action, null, 2, null).toString(), onSuccess, (Function1)new Function1<VolleyError, Unit>(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VolleyError it) {
                XS2AWizardConfig xS2AWizardConfig;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XS2AWizardConfig xS2AWizardConfig2 = XS2AWizardViewModel.access$getConfig$p(this.this$0);
                if (xS2AWizardConfig2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    xS2AWizardConfig = null;
                } else {
                    xS2AWizardConfig = xS2AWizardConfig2;
                }
                xS2AWizardConfig.getOnNetworkError().invoke();
            }
        });
    }

    public final void handleAnnotationClick(@NotNull Activity activity, @NotNull AnnotatedString.Range<String> annotation) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        String string2 = annotation.getTag();
        if (Intrinsics.areEqual((Object)string2, (Object)"autosubmit")) {
            JsonObject jsonBody = MarkupParser.INSTANCE.parseAutoSubmitPayloadAsJson((String)annotation.getItem());
            XS2AWizardViewModel.submitForm$default(this, (JsonElement)this.constructJsonBody("autosubmit", jsonBody), false, 2, null);
        } else {
            new CustomTabsIntent.Builder().build().launchUrl((Context)activity, Uri.parse((String)((String)annotation.getItem())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onFormReceived(String jsonString) {
        StringFormat $this$decodeFromString$iv = (StringFormat)JSONFormatter.INSTANCE.getFormatter();
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(FormResponse.class));
        boolean $i$f$cast = false;
        FormResponse formResponse = (FormResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonString);
        if (Utils.INSTANCE.checkIfLanguageNeedsToBeChanged(formResponse.getLanguage())) {
            void $this$onFormReceived_u24lambda_u2d10;
            boolean $i$f$buildJsonObject = false;
            $i$f$decodeFromString = false;
            JsonObjectBuilder builder$iv = new JsonObjectBuilder();
            $this$serializer$iv$iv = builder$iv;
            XS2AWizardViewModel xS2AWizardViewModel = this;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2d10, (String)"action", (String)"change-language");
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2d10, (String)"language", (String)Locale.getDefault().getLanguage());
            Unit unit = Unit.INSTANCE;
            XS2AWizardViewModel.submitForm$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
            return;
        }
        this.form.setValue(formResponse.getForm());
        this.loadingIndicatorLock.setValue((Object)false);
        this.parseCallback(formResponse);
    }

    private final void parseCallback(FormResponse response) {
        Object object = response.getCallback();
        if (Intrinsics.areEqual((Object)object, (Object)"finish")) {
            JsonPrimitive jsonPrimitive;
            JsonElement jsonElement;
            XS2AWizardConfig xS2AWizardConfig;
            Object object2 = this.config;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                xS2AWizardConfig = null;
            } else {
                xS2AWizardConfig = object2;
            }
            object2 = response.getCallbackParams();
            xS2AWizardConfig.getOnFinish().invoke(object2 == null ? null : ((jsonElement = (JsonElement)CollectionsKt.getOrNull((List)object2, (int)0)) == null ? null : ((jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) == null ? null : jsonPrimitive.getContent())));
        } else if (Intrinsics.areEqual((Object)object, (Object)"abort")) {
            XS2AWizardConfig xS2AWizardConfig;
            XS2AWizardConfig xS2AWizardConfig2 = this.config;
            if (xS2AWizardConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                xS2AWizardConfig = null;
            } else {
                xS2AWizardConfig = xS2AWizardConfig2;
            }
            xS2AWizardConfig.getOnAbort().invoke();
        }
        if (response.getError() != null) {
            Object object3;
            object = this.config;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                object3 = null;
            } else {
                object3 = object;
            }
            object = response.isErrorRecoverable();
            ((XS2AWizardConfig)object3).getOnError().invoke((Object)XS2AWizardError.Companion.getRelevantError(response.getError(), object == null ? false : (Boolean)object));
        }
    }

    public final void openWebView(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.currentWebViewUrl.setValue((Object)url);
    }

    public final void closeWebView() {
        this.currentWebViewUrl.setValue(null);
    }

    public static final /* synthetic */ void access$onFormReceived(XS2AWizardViewModel $this, String jsonString) {
        $this.onFormReceived(jsonString);
    }

    public static final /* synthetic */ XS2AWizardConfig access$getConfig$p(XS2AWizardViewModel $this) {
        return $this.config;
    }
}

