/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.components;

import android.graphics.Rect;
import android.text.Spannable;
import android.text.method.TransformationMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import com.fintecsystems.xs2awizard.components.CustomTabsURLSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J6\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/fintecsystems/xs2awizard/components/LinkTransformationMethod;", "Landroid/text/method/TransformationMethod;", "()V", "getTransformation", "", "source", "view", "Landroid/view/View;", "onFocusChanged", "", "sourceText", "focused", "", "direction", "", "previouslyFocusedRect", "Landroid/graphics/Rect;", "xs2awizard_release"})
public final class LinkTransformationMethod
implements TransformationMethod {
    @NotNull
    public CharSequence getTransformation(@NotNull CharSequence source, @Nullable View view) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (view instanceof TextView) {
            if (((TextView)view).getText() == null || !(((TextView)view).getText() instanceof Spannable)) {
                return source;
            }
            CharSequence charSequence = ((TextView)view).getText();
            if (charSequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.text.Spannable");
            }
            Spannable text = (Spannable)charSequence;
            URLSpan[] spans = (URLSpan[])text.getSpans(0, ((TextView)view).length(), URLSpan.class);
            int n = spans.length + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    URLSpan oldSpan = spans[i];
                    int start = text.getSpanStart((Object)oldSpan);
                    int end = text.getSpanEnd((Object)oldSpan);
                    String url = oldSpan.getURL();
                    text.removeSpan((Object)oldSpan);
                    Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                    text.setSpan((Object)new CustomTabsURLSpan(url), start, end, 33);
                } while (0 <= n);
            }
            return (CharSequence)text;
        }
        return source;
    }

    public void onFocusChanged(@Nullable View view, @Nullable CharSequence sourceText, boolean focused, int direction, @Nullable Rect previouslyFocusedRect) {
    }
}

