/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.helper.JsonSerializer;
import com.fintecsystems.xs2a.java.models.EventsList;
import com.fintecsystems.xs2a.java.models.PayObject;
import com.fintecsystems.xs2a.java.models.PayTransactionList;
import com.fintecsystems.xs2a.java.models.PaymentStatus;
import com.fintecsystems.xs2a.java.models.RefundPayoutList;
import com.fintecsystems.xs2a.java.models.RefundPayoutRequest;
import com.fintecsystems.xs2a.java.models.RefundPayoutResponse;
import com.fintecsystems.xs2a.java.models.RefundsPayout;
import com.fintecsystems.xs2a.java.models.ReportFormat;
import com.fintecsystems.xs2a.java.models.ReportLocale;
import com.fintecsystems.xs2a.java.models.WizardSessionResponse;
import com.fintecsystems.xs2a.java.models.Xs2aPay;
import com.fintecsystems.xs2a.java.services.ApiService;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0003J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0003J,\u0010\u0019\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u00cb\u0001\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u00101J\u001a\u00102\u001a\u0002032\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u0016\u00104\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00032\u0006\u00105\u001a\u000206R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/fintecsystems/xs2a/java/services/PayService;", "", "apiKey", "", "(Ljava/lang/String;)V", "create", "Lcom/fintecsystems/xs2a/java/models/WizardSessionResponse;", "body", "Lcom/fintecsystems/xs2a/java/models/Xs2aPay;", "delete", "transactionId", "generatePainFile", "Lcom/fintecsystems/xs2a/java/models/RefundPayoutResponse;", "Lcom/fintecsystems/xs2a/java/models/RefundPayoutRequest;", "get", "Lcom/fintecsystems/xs2a/java/models/PayObject;", "getEvents", "Lcom/fintecsystems/xs2a/java/models/EventsList;", "perPage", "", "page", "getPainFile", "messageId", "getRefundPayout", "Lcom/fintecsystems/xs2a/java/models/RefundsPayout;", "getReport", "reportId", "format", "Lcom/fintecsystems/xs2a/java/models/ReportFormat;", "locale", "Lcom/fintecsystems/xs2a/java/models/ReportLocale;", "list", "Lcom/fintecsystems/xs2a/java/models/PayTransactionList;", "senderHolder", "senderIban", "senderBic", "senderAccountNumber", "senderBankCode", "senderCountryId", "recipientHolder", "recipientIban", "recipientBic", "recipientCountryId", "amount", "", "purpose", "from", "Ljava/time/LocalDateTime;", "to", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Float;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)Lcom/fintecsystems/xs2a/java/models/PayTransactionList;", "listRefundPayouts", "Lcom/fintecsystems/xs2a/java/models/RefundPayoutList;", "updatePaymentStatus", "statusToSet", "Lcom/fintecsystems/xs2a/java/models/PaymentStatus;", "xs2a-java"})
public final class PayService {
    @NotNull
    private final String apiKey;

    public PayService(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    @NotNull
    public final WizardSessionResponse create(@NotNull Xs2aPay body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string = this_$iv.getMoshi().adapter(Xs2aPay.class).toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.post("payments", string);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(WizardSessionResponse.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (WizardSessionResponse)object;
    }

    @NotNull
    public final PayObject get(@NotNull String transactionId) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), Intrinsics.stringPlus((String)"payments/", (Object)transactionId), null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(PayObject.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (PayObject)object;
    }

    @NotNull
    public final PayObject updatePaymentStatus(@NotNull String transactionId, @NotNull PaymentStatus statusToSet) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)((Object)statusToSet), (String)"statusToSet");
        String string = statusToSet.getValue();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String statusValue = string3;
        String response = ApiService.post$default(new ApiService(this.apiKey, null, 2, null), "payments/" + transactionId + '/' + statusValue, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(PayObject.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (PayObject)object;
    }

    @NotNull
    public final Object getReport(@NotNull String transactionId, @NotNull String reportId, @NotNull ReportFormat format, @NotNull ReportLocale locale) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)locale), (String)"locale");
        String uri = "payments/" + transactionId + "/report";
        CharSequence charSequence = reportId;
        boolean bl = false;
        if (charSequence.length() > 0) {
            uri = uri + '/' + reportId;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"format", (Object)format.getValue()), TuplesKt.to((Object)"locale", (Object)locale.getValue())};
        Map queryParameters = MapsKt.mutableMapOf((Pair[])pairArray);
        String response = new ApiService(this.apiKey, null, 2, null).get(uri, queryParameters);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(Object.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    public static /* synthetic */ Object getReport$default(PayService payService, String string, String string2, ReportFormat reportFormat, ReportLocale reportLocale, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            reportFormat = ReportFormat.JSON;
        }
        if ((n & 8) != 0) {
            reportLocale = ReportLocale.EN;
        }
        return payService.getReport(string, string2, reportFormat, reportLocale);
    }

    @NotNull
    public final EventsList getEvents(@NotNull String transactionId, int perPage, int page) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(perPage)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        Map queryParameters = MapsKt.mutableMapOf((Pair[])pairArray);
        String response = new ApiService(this.apiKey, null, 2, null).get("payments/" + transactionId + "/events", queryParameters);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(EventsList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (EventsList)object;
    }

    public static /* synthetic */ EventsList getEvents$default(PayService payService, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 15;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return payService.getEvents(string, n, n2);
    }

    @NotNull
    public final RefundPayoutResponse generatePainFile(@NotNull RefundPayoutRequest body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string = this_$iv.getMoshi().adapter(RefundPayoutRequest.class).toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.post("payments/refundPayout", string);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(RefundPayoutResponse.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (RefundPayoutResponse)object;
    }

    @NotNull
    public final RefundPayoutList listRefundPayouts(int perPage, int page) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(perPage)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        Map queryParameters = MapsKt.mutableMapOf((Pair[])pairArray);
        String response = new ApiService(this.apiKey, null, 2, null).get("payments/refundPayout", queryParameters);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(RefundPayoutList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (RefundPayoutList)object;
    }

    public static /* synthetic */ RefundPayoutList listRefundPayouts$default(PayService payService, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 15;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return payService.listRefundPayouts(n, n2);
    }

    @NotNull
    public final RefundsPayout getRefundPayout(@NotNull String transactionId) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), "payments/" + transactionId + "/refundPayout", null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(RefundsPayout.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (RefundsPayout)object;
    }

    @NotNull
    public final String getPainFile(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return ApiService.get$default(new ApiService(this.apiKey, null, 2, null), Intrinsics.stringPlus((String)"payments/refundPayout/", (Object)messageId), null, 2, null);
    }

    @NotNull
    public final String delete(@NotNull String transactionId) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        return new ApiService(this.apiKey, null, 2, null).delete(Intrinsics.stringPlus((String)"payments/", (Object)transactionId));
    }

    @NotNull
    public final PayTransactionList list(@Nullable String senderHolder, @Nullable String senderIban, @Nullable String senderBic, @Nullable String senderAccountNumber, @Nullable String senderBankCode, @Nullable String senderCountryId, @Nullable String recipientHolder, @Nullable String recipientIban, @Nullable String recipientBic, @Nullable String recipientCountryId, @Nullable Float amount, @Nullable String purpose, @Nullable Integer perPage, @Nullable Integer page, @Nullable LocalDateTime from, @Nullable LocalDateTime to) {
        String amountToUse = amount != null ? amount.toString() : null;
        String perPageToUse = perPage != null ? perPage.toString() : null;
        String pageToUse = page != null ? page.toString() : null;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"senderHolder", (Object)senderHolder), TuplesKt.to((Object)"senderIban", (Object)senderIban), TuplesKt.to((Object)"senderBic", (Object)senderBic), TuplesKt.to((Object)"senderAccountNumber", (Object)senderAccountNumber), TuplesKt.to((Object)"senderBankCode", (Object)senderBankCode), TuplesKt.to((Object)"senderCountryId", (Object)senderCountryId), TuplesKt.to((Object)"recipientHolder", (Object)recipientHolder), TuplesKt.to((Object)"recipientIban", (Object)recipientIban), TuplesKt.to((Object)"recipientBic", (Object)recipientBic), TuplesKt.to((Object)"recipientCountryId", (Object)recipientCountryId), TuplesKt.to((Object)"amount", (Object)amountToUse), TuplesKt.to((Object)"purpose", (Object)purpose), TuplesKt.to((Object)"per_page", (Object)perPageToUse), TuplesKt.to((Object)"page", (Object)pageToUse), TuplesKt.to((Object)"from", (Object)from), TuplesKt.to((Object)"to", (Object)to)};
        String response = new ApiService(this.apiKey, null, 2, null).get("payments", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(PayTransactionList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (PayTransactionList)object;
    }

    public static /* synthetic */ PayTransactionList list$default(PayService payService, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, Float f, String string11, Integer n, Integer n2, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = null;
        }
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            string3 = null;
        }
        if ((n3 & 8) != 0) {
            string4 = null;
        }
        if ((n3 & 0x10) != 0) {
            string5 = null;
        }
        if ((n3 & 0x20) != 0) {
            string6 = null;
        }
        if ((n3 & 0x40) != 0) {
            string7 = null;
        }
        if ((n3 & 0x80) != 0) {
            string8 = null;
        }
        if ((n3 & 0x100) != 0) {
            string9 = null;
        }
        if ((n3 & 0x200) != 0) {
            string10 = null;
        }
        if ((n3 & 0x400) != 0) {
            f = null;
        }
        if ((n3 & 0x800) != 0) {
            string11 = null;
        }
        if ((n3 & 0x1000) != 0) {
            n = null;
        }
        if ((n3 & 0x2000) != 0) {
            n2 = null;
        }
        if ((n3 & 0x4000) != 0) {
            localDateTime = null;
        }
        if ((n3 & 0x8000) != 0) {
            localDateTime2 = null;
        }
        return payService.list(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, f, string11, n, n2, localDateTime, localDateTime2);
    }
}

