/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.helper.JsonSerializer;
import com.fintecsystems.xs2a.java.models.BankAccount;
import com.fintecsystems.xs2a.java.models.BankAccountBalance;
import com.fintecsystems.xs2a.java.models.BankAccountTurnovers;
import com.fintecsystems.xs2a.java.models.BankAccountsList;
import com.fintecsystems.xs2a.java.models.ReportFormat;
import com.fintecsystems.xs2a.java.models.ReportLocale;
import com.fintecsystems.xs2a.java.services.ApiService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0003J*\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J7\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ\"\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ\u001a\u0010 \u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/fintecsystems/xs2a/java/services/ApiBankAccountService;", "", "apiKey", "", "(Ljava/lang/String;)V", "delete", "bankAccountId", "get", "Lcom/fintecsystems/xs2a/java/models/BankAccount;", "getBalance", "Lcom/fintecsystems/xs2a/java/models/BankAccountBalance;", "getReport", "reportId", "format", "Lcom/fintecsystems/xs2a/java/models/ReportFormat;", "locale", "Lcom/fintecsystems/xs2a/java/models/ReportLocale;", "getTurnovers", "Lcom/fintecsystems/xs2a/java/models/BankAccountTurnovers;", "from", "Ljava/time/LocalDateTime;", "to", "onlyNew", "", "(Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;Ljava/lang/Boolean;)Lcom/fintecsystems/xs2a/java/models/BankAccountTurnovers;", "list", "Lcom/fintecsystems/xs2a/java/models/BankAccountsList;", "per_page", "", "page", "listForBankConnection", "connectionId", "markAsSeen", "upTo", "xs2a-java"})
public final class ApiBankAccountService {
    @NotNull
    private final String apiKey;

    public ApiBankAccountService(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    @NotNull
    public final BankAccountsList list(int per_page, int page) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        String response = new ApiService(this.apiKey, null, 2, null).get("api/accounts", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankAccountsList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankAccountsList)object;
    }

    public static /* synthetic */ BankAccountsList list$default(ApiBankAccountService apiBankAccountService, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 15;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return apiBankAccountService.list(n, n2);
    }

    @NotNull
    public final BankAccountsList listForBankConnection(@NotNull String connectionId, int per_page, int page) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        String response = new ApiService(this.apiKey, null, 2, null).get("api/connections/" + connectionId + "/accounts", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankAccountsList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankAccountsList)object;
    }

    public static /* synthetic */ BankAccountsList listForBankConnection$default(ApiBankAccountService apiBankAccountService, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 15;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return apiBankAccountService.listForBankConnection(string, n, n2);
    }

    @NotNull
    public final BankAccount get(@NotNull String bankAccountId) {
        Intrinsics.checkNotNullParameter((Object)bankAccountId, (String)"bankAccountId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), Intrinsics.stringPlus((String)"api/accounts/", (Object)bankAccountId), null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankAccount.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankAccount)object;
    }

    @NotNull
    public final String delete(@NotNull String bankAccountId) {
        Intrinsics.checkNotNullParameter((Object)bankAccountId, (String)"bankAccountId");
        return new ApiService(this.apiKey, null, 2, null).delete(Intrinsics.stringPlus((String)"api/accounts/", (Object)bankAccountId));
    }

    @NotNull
    public final BankAccountBalance getBalance(@NotNull String bankAccountId) {
        Intrinsics.checkNotNullParameter((Object)bankAccountId, (String)"bankAccountId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), "api/accounts/" + bankAccountId + "/balance", null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankAccountBalance.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankAccountBalance)object;
    }

    @NotNull
    public final BankAccountTurnovers getTurnovers(@NotNull String bankAccountId, @Nullable LocalDateTime from, @Nullable LocalDateTime to, @Nullable Boolean onlyNew) {
        Intrinsics.checkNotNullParameter((Object)bankAccountId, (String)"bankAccountId");
        int onlyNewToUse = 0;
        if (onlyNew != null) {
            onlyNewToUse = 1;
        }
        String fromToUse = null;
        if (from != null) {
            fromToUse = from.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        String toToUse = null;
        if (to != null) {
            toToUse = to.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from", (Object)fromToUse), TuplesKt.to((Object)"to", (Object)toToUse), TuplesKt.to((Object)"onlyNew", (Object)onlyNewToUse)};
        String response = new ApiService(this.apiKey, null, 2, null).get("api/accounts/" + bankAccountId + "/turnovers", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankAccountTurnovers.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankAccountTurnovers)object;
    }

    public static /* synthetic */ BankAccountTurnovers getTurnovers$default(ApiBankAccountService apiBankAccountService, String string, LocalDateTime localDateTime, LocalDateTime localDateTime2, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            localDateTime = null;
        }
        if ((n & 4) != 0) {
            localDateTime2 = null;
        }
        if ((n & 8) != 0) {
            bl = null;
        }
        return apiBankAccountService.getTurnovers(string, localDateTime, localDateTime2, bl);
    }

    @NotNull
    public final Object markAsSeen(@NotNull String bankAccountId, @Nullable LocalDateTime upTo) {
        Intrinsics.checkNotNullParameter((Object)bankAccountId, (String)"bankAccountId");
        String uri = "api/accounts/" + bankAccountId + "/markAsSeen";
        if (upTo != null) {
            uri = uri + '/' + upTo;
        }
        String response = ApiService.post$default(new ApiService(this.apiKey, null, 2, null), uri, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(Object.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    public static /* synthetic */ Object markAsSeen$default(ApiBankAccountService apiBankAccountService, String string, LocalDateTime localDateTime, int n, Object object) {
        if ((n & 2) != 0) {
            localDateTime = null;
        }
        return apiBankAccountService.markAsSeen(string, localDateTime);
    }

    @NotNull
    public final String getReport(@NotNull String bankAccountId, @NotNull String reportId, @NotNull ReportFormat format, @NotNull ReportLocale locale) {
        Intrinsics.checkNotNullParameter((Object)bankAccountId, (String)"bankAccountId");
        Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)locale), (String)"locale");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"format", (Object)format.getValue()), TuplesKt.to((Object)"locale", (Object)locale.getValue())};
        return new ApiService(this.apiKey, null, 2, null).get("api/accounts/" + bankAccountId + "/report/" + reportId, MapsKt.mutableMapOf((Pair[])pairArray));
    }

    public static /* synthetic */ String getReport$default(ApiBankAccountService apiBankAccountService, String string, String string2, ReportFormat reportFormat, ReportLocale reportLocale, int n, Object object) {
        if ((n & 4) != 0) {
            reportFormat = ReportFormat.JSON;
        }
        if ((n & 8) != 0) {
            reportLocale = ReportLocale.EN;
        }
        return apiBankAccountService.getReport(string, string2, reportFormat, reportLocale);
    }
}

