/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;

public abstract class Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    public int offset = -1;
    public int type = 0;
    private boolean hyperlink = false;
    private Token nextToken = null;
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    public static final int NULL = 0;
    public static final int COMMENT_EOL = 1;
    public static final int COMMENT_MULTILINE = 2;
    public static final int COMMENT_DOCUMENTATION = 3;
    public static final int RESERVED_WORD = 4;
    public static final int FUNCTION = 5;
    public static final int LITERAL_BOOLEAN = 6;
    public static final int LITERAL_NUMBER_DECIMAL_INT = 7;
    public static final int LITERAL_NUMBER_FLOAT = 8;
    public static final int LITERAL_NUMBER_HEXADECIMAL = 9;
    public static final int LITERAL_STRING_DOUBLE_QUOTE = 10;
    public static final int LITERAL_CHAR = 11;
    public static final int LITERAL_BACKQUOTE = 12;
    public static final int DATA_TYPE = 13;
    public static final int VARIABLE = 14;
    public static final int IDENTIFIER = 15;
    public static final int WHITESPACE = 16;
    public static final int SEPARATOR = 17;
    public static final int OPERATOR = 18;
    public static final int PREPROCESSOR = 19;
    public static final int MARKUP_TAG_DELIMITER = 20;
    public static final int MARKUP_TAG_NAME = 21;
    public static final int MARKUP_TAG_ATTRIBUTE = 22;
    public static final int ERROR_IDENTIFIER = 23;
    public static final int ERROR_NUMBER_FORMAT = 24;
    public static final int ERROR_STRING_DOUBLE = 25;
    public static final int ERROR_CHAR = 26;
    public static final int NUM_TOKEN_TYPES = 27;

    public Token() {
    }

    public Token(char[] line, int beg, int end, int startOffset, int type) {
        this();
        this.set(line, beg, end, startOffset, type);
    }

    public Token(Token t2) {
        this();
        this.copyFrom(t2);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer sb, RSyntaxTextArea textArea, boolean fontFamily) {
        SyntaxScheme colorScheme = textArea.getSyntaxScheme();
        Style scheme = colorScheme.styles[this.type];
        Font font = textArea.getFontForTokenType(this.type);
        if (font.isBold()) {
            sb.append("<b>");
        }
        if (font.isItalic()) {
            sb.append("<em>");
        }
        if (scheme.underline) {
            sb.append("<u>");
        }
        sb.append("<font");
        if (fontFamily) {
            sb.append(" face=\"").append(font.getFamily()).append("\"");
        }
        sb.append(" color=\"").append(Token.getHTMLFormatForColor(scheme.foreground)).append("\">");
        this.appendHtmlLexeme(sb);
        sb.append("</font>");
        if (scheme.underline) {
            sb.append("</u>");
        }
        if (font.isItalic()) {
            sb.append("</em>");
        }
        if (font.isBold()) {
            sb.append("</b>");
        }
        return sb;
    }

    private final StringBuffer appendHtmlLexeme(StringBuffer sb) {
        int i;
        int lastI = i = this.textOffset;
        while (i < this.textOffset + this.textCount) {
            char ch = this.text[i];
            switch (ch) {
                case '\t': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&nbsp;");
                    break;
                }
                case '<': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&gt;");
                }
            }
            ++i;
        }
        if (lastI < this.textOffset + this.textCount) {
            sb.append(this.text, lastI, this.textOffset + this.textCount - lastI);
        }
        return sb;
    }

    public boolean containsPosition(int pos) {
        return pos >= this.offset && pos < this.offset + this.textCount;
    }

    public void copyFrom(Token t2) {
        this.text = t2.text;
        this.textOffset = t2.textOffset;
        this.textCount = t2.textCount;
        this.offset = t2.offset;
        this.type = t2.type;
        this.nextToken = t2.nextToken;
    }

    public int documentToToken(int pos) {
        return pos + (this.textOffset - this.offset);
    }

    private static final String getHTMLFormatForColor(Color color) {
        String hexBlue;
        String hexGreen;
        if (color == null) {
            return "black";
        }
        String hexRed = Integer.toHexString(color.getRed());
        if (hexRed.length() == 1) {
            hexRed = "0" + hexRed;
        }
        if ((hexGreen = Integer.toHexString(color.getGreen())).length() == 1) {
            hexGreen = "0" + hexGreen;
        }
        if ((hexBlue = Integer.toHexString(color.getBlue())).length() == 1) {
            hexBlue = "0" + hexBlue;
        }
        return "#" + hexRed + hexGreen + hexBlue;
    }

    public String getHTMLRepresentation(RSyntaxTextArea textArea) {
        StringBuffer buf = new StringBuffer();
        this.appendHTMLRepresentation(buf, textArea, true);
        return buf.toString();
    }

    public Token getLastNonCommentNonWhitespaceToken() {
        Token last = null;
        Token t = this;
        while (t != null && t.isPaintable()) {
            switch (t.type) {
                case 1: 
                case 2: 
                case 3: 
                case 16: {
                    break;
                }
                default: {
                    last = t;
                }
            }
            t = t.nextToken;
        }
        return last;
    }

    public Token getLastPaintableToken() {
        Token t = this;
        while (t.isPaintable()) {
            if (t.nextToken == null || !t.nextToken.isPaintable()) {
                return t;
            }
            t = t.nextToken;
        }
        return null;
    }

    public String getLexeme() {
        return new String(this.text, this.textOffset, this.textCount);
    }

    public abstract int getListOffset(RSyntaxTextArea var1, TabExpander var2, float var3, float var4);

    public Token getNextToken() {
        return this.nextToken;
    }

    public int getOffsetBeforeX(RSyntaxTextArea textArea, TabExpander e, float startX, float endBeforeX) {
        int i;
        FontMetrics fm = textArea.getFontMetricsForTokenType(this.type);
        int stop = i + this.textCount;
        float x = startX;
        for (i = this.textOffset; i < stop; ++i) {
            x = this.text[i] == '\t' ? e.nextTabStop(x, 0) : (x += (float)fm.charWidth(this.text[i]));
            if (!(x > endBeforeX)) continue;
            int intoToken = Math.max(i - this.textOffset, 1);
            return this.offset + intoToken;
        }
        return this.offset + this.textCount - 1;
    }

    public float getWidth(RSyntaxTextArea textArea, TabExpander e, float x0) {
        return this.getWidthUpTo(this.textCount, textArea, e, x0);
    }

    public abstract float getWidthUpTo(int var1, RSyntaxTextArea var2, TabExpander var3, float var4);

    public boolean is(int type, String lexeme) {
        return this.type == type && this.textCount == lexeme.length() && lexeme.equals(this.getLexeme());
    }

    public boolean isComment() {
        return this.type >= 1 && this.type <= 3;
    }

    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public boolean isLeftCurly() {
        return this.type == 17 && this.isSingleChar('{');
    }

    public boolean isRightCurly() {
        return this.type == 17 && this.isSingleChar('}');
    }

    public boolean isPaintable() {
        return this.type > 0;
    }

    public boolean isSingleChar(char ch) {
        return this.textCount == 1 && this.text[this.textOffset] == ch;
    }

    public boolean isWhitespace() {
        return this.type == 16;
    }

    public abstract Rectangle listOffsetToView(RSyntaxTextArea var1, TabExpander var2, int var3, int var4, Rectangle var5);

    public void makeStartAt(int pos) {
        if (pos < this.offset || pos >= this.offset + this.textCount) {
            throw new IllegalArgumentException("pos " + pos + " is not in range " + this.offset + "-" + (this.offset + this.textCount - 1));
        }
        int shift = pos - this.offset;
        this.offset = pos;
        this.textOffset += shift;
        this.textCount -= shift;
    }

    public void moveOffset(int amt) {
        if (amt < 0 || amt > this.textCount) {
            throw new IllegalArgumentException("amt " + amt + " is not in range 0-" + this.textCount);
        }
        this.offset += amt;
        this.textOffset += amt;
        this.textCount -= amt;
    }

    public final float paint(Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e) {
        return this.paint(g, x, y, host, e, 0.0f);
    }

    public abstract float paint(Graphics2D var1, float var2, float var3, RSyntaxTextArea var4, TabExpander var5, float var6);

    protected void paintBackground(float x, float y, float width, float height, Graphics2D g, int fontAscent, RSyntaxTextArea host, Color color) {
        Color temp = host.getBackground();
        g.setXORMode(temp != null ? temp : Color.WHITE);
        g.setColor(color);
        this.bgRect.setRect(x, y - (float)fontAscent, width, height);
        g.fill(this.bgRect);
        g.setPaintMode();
    }

    public void set(char[] line, int beg, int end, int offset, int type) {
        this.text = line;
        this.textOffset = beg;
        this.textCount = end - beg + 1;
        this.type = type;
        this.offset = offset;
        this.nextToken = null;
    }

    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setNextToken(Token nextToken) {
        this.nextToken = nextToken;
    }

    public int tokenToDocument(int pos) {
        return pos + (this.offset - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.type == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; " + "offset: " + this.offset + "; type: " + this.type + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

