/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.AbstractJFlexTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;

public abstract class AbstractJFlexCTokenMaker
extends AbstractJFlexTokenMaker {
    protected static final Action INSERT_BREAK_ACTION = new InsertBreakAction();

    public boolean getCurlyBracesDenoteCodeBlocks() {
        return true;
    }

    public Action getInsertBreakAction() {
        return INSERT_BREAK_ACTION;
    }

    public boolean getShouldIndentNextLineAfter(Token t) {
        if (t != null && t.textCount == 1) {
            char ch = t.text[t.textOffset];
            return ch == '{' || ch == '(';
        }
        return false;
    }

    private static class InsertBreakAction
    extends RSyntaxTextAreaEditorKit.InsertBreakAction {
        private static final Pattern p = Pattern.compile("([ \\t]*)(/?[\\*]+)([ \\t]*)");

        private InsertBreakAction() {
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            int line;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea rsta = (RSyntaxTextArea)this.getTextComponent(e);
            RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
            int type = doc.getLastTokenTypeOnLine(line = textArea.getCaretLineNumber());
            if (type == 3 || type == 2) {
                this.insertBreakInMLC(e, rsta, line);
            } else {
                this.handleInsertBreak(rsta, true);
            }
        }

        private void insertBreakInMLC(ActionEvent e, RSyntaxTextArea textArea, int line) {
            Matcher m = null;
            int start = -1;
            int end = -1;
            try {
                start = textArea.getLineStartOffset(line);
                end = textArea.getLineEndOffset(line);
                String text = textArea.getText(start, end - start);
                m = p.matcher(text);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                ble.printStackTrace();
                return;
            }
            if (m.lookingAt()) {
                String leadingWS = m.group(1);
                String mlcMarker = m.group(2);
                int dot = textArea.getCaretPosition();
                if (dot >= start && dot < start + leadingWS.length() + mlcMarker.length()) {
                    textArea.setCaretPosition(end - 1);
                }
                boolean newMLC = mlcMarker.charAt(0) == '/';
                String header = leadingWS + (newMLC ? " * " : "*") + m.group(3);
                textArea.replaceSelection("\n" + header);
                if (newMLC) {
                    dot = textArea.getCaretPosition();
                    textArea.insert("\n" + leadingWS + " */", dot);
                    textArea.setCaretPosition(dot);
                }
            } else {
                this.handleInsertBreak(textArea, true);
            }
        }
    }
}

