/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;

public class DefaultParserNotice
implements ParserNotice {
    private Parser parser;
    private int level;
    private int line;
    private int offset;
    private int length;
    private boolean showInEditor;
    private Color color;
    private String message;
    private String toolTipText;

    public DefaultParserNotice(Parser parser, String msg, int line) {
        this(parser, msg, line, -1, -1);
    }

    public DefaultParserNotice(Parser parser, String message, int line, int offset, int length) {
        this.parser = parser;
        this.message = message;
        this.line = line;
        this.offset = offset;
        this.length = length;
        this.setLevel(0);
        this.setShowInEditor(true);
    }

    public int compareTo(Object obj) {
        ParserNotice p2;
        int diff = -1;
        if (obj instanceof ParserNotice && (diff = this.level - (p2 = (ParserNotice)obj).getLevel()) == 0 && (diff = this.line - p2.getLine()) == 0) {
            diff = this.message.compareTo(p2.getMessage());
        }
        return diff;
    }

    public boolean containsPosition(int pos) {
        return this.offset <= pos && pos < this.offset + this.length;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLength() {
        return this.length;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public int getOffset() {
        return this.offset;
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean getShowInEditor() {
        return this.showInEditor;
    }

    public String getToolTipText() {
        return this.toolTipText != null ? this.toolTipText : this.getMessage();
    }

    public int hashCode() {
        return this.line << 16 | this.offset;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLevel(int level) {
        if (level > 2) {
            level = 2;
        } else if (level < 0) {
            level = 0;
        }
        this.level = level;
    }

    public void setShowInEditor(boolean show) {
        this.showInEditor = show;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String toString() {
        return "Line " + this.getLine() + ": " + this.getMessage();
    }
}

