/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.fife.io.DocumentReader;
import org.fife.rsta.ac.xml.XmlLanguageSupport;
import org.fife.rsta.ac.xml.tree.XmlTreeNode;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlParser
extends AbstractParser {
    public static final String PROPERTY_AST = "XmlAST";
    private XmlLanguageSupport xls;
    private PropertyChangeSupport support;
    private XmlTreeNode curElem;
    private XmlTreeNode root;
    private Locator locator;

    public XmlParser(XmlLanguageSupport xls) {
        this.xls = xls;
        this.support = new PropertyChangeSupport((Object)this);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.support.addPropertyChangeListener(prop, l);
    }

    private XMLReader createReader() {
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            try {
                reader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException se) {
                se.printStackTrace();
            }
        }
        return reader;
    }

    public XmlTreeNode getAst() {
        return this.root;
    }

    private String getMainAttribute(Attributes attributes) {
        int i;
        int nameIndex = -1;
        int idIndex = -1;
        for (i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            if ("id".equals(name)) {
                idIndex = i;
                break;
            }
            if (!"name".equals(name)) continue;
            nameIndex = i;
        }
        if ((i = idIndex) == -1 && (i = nameIndex) == -1) {
            i = 0;
        }
        return attributes.getLocalName(i) + "=" + attributes.getValue(i);
    }

    public ParseResult parse(RSyntaxDocument doc, String style) {
        DefaultParseResult result = new DefaultParseResult((Parser)this);
        this.curElem = this.root = new XmlTreeNode("Root");
        try {
            XMLReader xr = this.createReader();
            if (xr == null) {
                return result;
            }
            Handler handler = new Handler(doc, result);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            InputSource is = new InputSource((Reader)new DocumentReader((Document)doc));
            xr.parse(is);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.locator != null) {
            try {
                this.root.setStartOffset(doc.createPosition(0));
                this.root.setEndOffset(doc.createPosition(doc.getLength()));
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        this.support.firePropertyChange(PROPERTY_AST, null, this.root);
        return result;
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.support.removePropertyChangeListener(prop, l);
    }

    private class Handler
    extends DefaultHandler {
        private DefaultParseResult result;
        private RSyntaxDocument doc;
        private Segment s;

        public Handler(RSyntaxDocument doc, DefaultParseResult result) {
            this.doc = doc;
            this.result = result;
            this.s = new Segment();
        }

        private void doError(SAXParseException e, int level) {
            if (!XmlParser.this.xls.getShowSyntaxErrors()) {
                return;
            }
            int line = e.getLineNumber() - 1;
            Element root = this.doc.getDefaultRootElement();
            Element elem = root.getElement(line);
            int offs = elem.getStartOffset();
            int len = elem.getEndOffset() - offs;
            if (line == root.getElementCount() - 1) {
                ++len;
            }
            DefaultParserNotice pn = new DefaultParserNotice((Parser)XmlParser.this, e.getMessage(), line, offs, len);
            pn.setLevel(level);
            this.result.addNotice((ParserNotice)pn);
        }

        public void endElement(String uri, String localName, String qName) {
            XmlParser.this.curElem = (XmlTreeNode)XmlParser.this.curElem.getParent();
        }

        public void error(SAXParseException e) throws SAXException {
            this.doError(e, 0);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.doError(e, 0);
        }

        private int getTagStart(int end) {
            Element root = this.doc.getDefaultRootElement();
            int line = root.getElementIndex(end);
            Element elem = root.getElement(line);
            int start = elem.getStartOffset();
            int lastCharOffs = -1;
            try {
                while (line >= 0) {
                    this.doc.getText(start, end - start, this.s);
                    for (int i = this.s.offset + this.s.count - 1; i >= this.s.offset; --i) {
                        char ch = this.s.array[i];
                        if (ch == '<') {
                            return lastCharOffs;
                        }
                        if (!Character.isLetterOrDigit(ch)) continue;
                        lastCharOffs = start + i - this.s.offset;
                    }
                    if (--line < 0) continue;
                    elem = root.getElement(line);
                    start = elem.getStartOffset();
                    end = elem.getEndOffset();
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            return -1;
        }

        public void setDocumentLocator(Locator l) {
            XmlParser.this.locator = l;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            int line;
            XmlTreeNode newElem = new XmlTreeNode(qName);
            if (attributes.getLength() > 0) {
                newElem.setMainAttribute(XmlParser.this.getMainAttribute(attributes));
            }
            if (XmlParser.this.locator != null && (line = XmlParser.this.locator.getLineNumber()) != -1) {
                int offs = this.doc.getDefaultRootElement().getElement(line - 1).getStartOffset();
                int col = XmlParser.this.locator.getColumnNumber();
                if (col != -1) {
                    offs += col - 1;
                }
                offs = this.getTagStart(offs);
                try {
                    newElem.setStartOffset(this.doc.createPosition(offs));
                    int endOffs = offs + qName.length();
                    newElem.setEndOffset(this.doc.createPosition(endOffs));
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            XmlParser.this.curElem.add(newElem);
            XmlParser.this.curElem = newElem;
        }

        public void warning(SAXParseException e) throws SAXException {
            this.doError(e, 1);
        }
    }
}

