/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.php;

import java.util.HashSet;
import java.util.Set;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractMarkupLanguageSupport;
import org.fife.rsta.ac.html.HtmlCellRenderer;
import org.fife.rsta.ac.html.HtmlLanguageSupport;
import org.fife.rsta.ac.php.PhpCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class PhpLanguageSupport
extends AbstractMarkupLanguageSupport {
    private PhpCompletionProvider provider;
    private static Set tagsToClose = new HashSet();

    public PhpLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(true);
        tagsToClose = HtmlLanguageSupport.getTagsToClose();
    }

    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new HtmlCellRenderer();
    }

    private PhpCompletionProvider getProvider() {
        if (this.provider == null) {
            this.provider = new PhpCompletionProvider();
        }
        return this.provider;
    }

    public void install(RSyntaxTextArea textArea) {
        PhpCompletionProvider provider = this.getProvider();
        AutoCompletion ac = this.createAutoCompletion((CompletionProvider)provider);
        ac.install((JTextComponent)textArea);
        this.installImpl(textArea, ac);
        this.installKeyboardShortcuts(textArea);
        textArea.setToolTipSupplier(null);
    }

    protected boolean shouldAutoCloseTag(String tag) {
        return tagsToClose.contains(tag.toLowerCase());
    }

    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
        this.uninstallKeyboardShortcuts(textArea);
    }
}

