/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.jsp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fife.rsta.ac.html.AttributeCompletion;
import org.fife.rsta.ac.html.HtmlCompletionProvider;
import org.fife.rsta.ac.jsp.TldAttribute;
import org.fife.rsta.ac.jsp.TldElement;
import org.fife.rsta.ac.jsp.TldFile;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.MarkupTagCompletion;

public class JspCompletionProvider
extends HtmlCompletionProvider {
    private Map prefixToTld = new HashMap();

    public JspCompletionProvider() {
        String fileName = File.separatorChar == '/' ? "/users/robert/struts-2.2.3/lib/struts2-core-2.2.3.jar" : "c:/dev/struts/struts-2.2.3/lib/struts2-core-2.2.3.jar";
        File file = new File(fileName);
        if (!file.exists()) {
            file = new File("C:/temp/struts2-core-2.2.1.jar");
        }
        try {
            this.prefixToTld.put("s", new TldFile(this, file));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.setAutoActivationRules(false, "<:");
    }

    protected List getAttributeCompletionsForTag(String tagName) {
        int colon;
        ArrayList<AttributeCompletion> list = super.getAttributeCompletionsForTag(tagName);
        if (list == null && (colon = tagName.indexOf(58)) > -1) {
            List attrs;
            String prefix = tagName.substring(0, colon);
            tagName = tagName.substring(colon + 1);
            TldFile tldFile = (TldFile)this.prefixToTld.get(prefix);
            if (tldFile != null && (attrs = tldFile.getAttributesForTag(tagName)) != null && attrs.size() > -1) {
                list = new ArrayList<AttributeCompletion>();
                for (int i = 0; i < attrs.size(); ++i) {
                    TldAttribute.TldAttributeParam param = (TldAttribute.TldAttributeParam)((Object)attrs.get(i));
                    list.add(new AttributeCompletion((CompletionProvider)this, param));
                }
            }
        }
        return list;
    }

    protected List getTagCompletions() {
        ArrayList<MarkupTagCompletion> completions = new ArrayList<MarkupTagCompletion>(super.getTagCompletions());
        for (Map.Entry entry : this.prefixToTld.entrySet()) {
            String prefix = (String)entry.getKey();
            TldFile tld = (TldFile)entry.getValue();
            for (int j = 0; j < tld.getElementCount(); ++j) {
                TldElement elem = tld.getElement(j);
                MarkupTagCompletion mtc = new MarkupTagCompletion((CompletionProvider)this, prefix + ":" + elem.getName());
                mtc.setDescription(elem.getDescription());
                completions.add(mtc);
            }
        }
        Collections.sort(completions);
        return completions;
    }

    protected void initCompletions() {
        super.initCompletions();
        try {
            this.loadFromXML("data/jsp.xml");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Collections.sort(this.completions, this.comparator);
    }

    protected boolean isValidChar(char ch) {
        return super.isValidChar(ch) || ch == ':';
    }
}

