/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.js.ast.parser;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.fife.rsta.ac.js.JavaScriptHelper;
import org.fife.rsta.ac.js.SourceCompletionProvider;
import org.fife.rsta.ac.js.ast.CodeBlock;
import org.fife.rsta.ac.js.ast.jsType.JavaScriptTypesFactory;
import org.fife.rsta.ac.js.ast.jsType.RhinoJavaScriptTypesFactory;
import org.fife.rsta.ac.js.ast.parser.JavaScriptAstParser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;

public class RhinoJavaScriptAstParser
extends JavaScriptAstParser {
    private LinkedHashSet importClasses = new LinkedHashSet();
    private LinkedHashSet importPackages = new LinkedHashSet();

    public RhinoJavaScriptAstParser(SourceCompletionProvider provider, int dot, boolean preProcessingMode) {
        super(provider, dot, preProcessingMode);
    }

    public void clearImportCache(SourceCompletionProvider provider) {
        JavaScriptTypesFactory typesFactory = provider.getJavaScriptTypesFactory();
        if (typesFactory instanceof RhinoJavaScriptTypesFactory) {
            ((RhinoJavaScriptTypesFactory)typesFactory).clearAllImports();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBlock convertAstNodeToCodeBlock(AstRoot root, Set set, String entered) {
        try {
            CodeBlock codeBlock = super.convertAstNodeToCodeBlock(root, set, entered);
            return codeBlock;
        }
        finally {
            this.mergeImportCache(this.importPackages, this.importClasses);
            this.importClasses.clear();
            this.importPackages.clear();
        }
    }

    private void mergeImportCache(HashSet packages, HashSet classes) {
        JavaScriptTypesFactory typesFactory = this.provider.getJavaScriptTypesFactory();
        if (typesFactory instanceof RhinoJavaScriptTypesFactory) {
            ((RhinoJavaScriptTypesFactory)typesFactory).mergeImports(packages, classes);
        }
    }

    protected void iterateNode(AstNode child, Set set, String entered, CodeBlock block, int offset) {
        switch (child.getType()) {
            case 134: {
                boolean importFound = this.processImportNode(child, set, entered, block, offset);
                if (!importFound) break;
                return;
            }
        }
        super.iterateNode(child, set, entered, block, offset);
    }

    private boolean processImportNode(AstNode child, Set set, String entered, CodeBlock block, int offset) {
        String src = JavaScriptHelper.convertNodeToSource(child);
        if (src != null) {
            if (src.startsWith("importPackage")) {
                this.processImportPackage(src);
                return true;
            }
            if (src.startsWith("importClass")) {
                this.processImportClass(src);
                return true;
            }
        }
        return false;
    }

    private String extractNameFromSrc(String src) {
        int startIndex = src.indexOf("(");
        int endIndex = src.indexOf(")");
        if (startIndex != -1 && endIndex != -1) {
            return src.substring(startIndex + 1, endIndex);
        }
        return src;
    }

    private void processImportPackage(String src) {
        String pkg = this.extractNameFromSrc(src);
        this.importPackages.add(pkg);
    }

    private void processImportClass(String src) {
        String cls = this.extractNameFromSrc(src);
        this.importClasses.add(cls);
    }
}

