/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.js.ast.jsType;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.js.ast.jsType.JSR223JavaScriptTypesFactory;
import org.fife.rsta.ac.js.ast.jsType.JavaScriptType;
import org.fife.rsta.ac.js.ast.type.TypeDeclaration;
import org.fife.rsta.ac.js.ast.type.TypeDeclarationFactory;

public class RhinoJavaScriptTypesFactory
extends JSR223JavaScriptTypesFactory {
    private LinkedHashSet importClasses = new LinkedHashSet();
    private LinkedHashSet importPackages = new LinkedHashSet();

    public void addImportClass(String qualifiedClass) {
        this.importClasses.add(qualifiedClass);
    }

    public void addImportPackage(String packageName) {
        this.importPackages.add(packageName);
    }

    public void mergeImports(HashSet packages, HashSet classes) {
        this.mergeImports(packages, this.importPackages, true);
        this.mergeImports(classes, this.importClasses, false);
    }

    private void mergeImports(HashSet newImports, LinkedHashSet oldImports, boolean packages) {
        HashSet remove = new HashSet();
        for (Object obj : oldImports) {
            if (newImports.contains(obj)) continue;
            remove.add(obj);
        }
        oldImports.clear();
        oldImports.addAll(newImports);
        if (!remove.isEmpty()) {
            HashSet<TypeDeclaration> removeTypes = new HashSet<TypeDeclaration>();
            for (String name : remove) {
                for (TypeDeclaration dec : this.cachedTypes.keySet()) {
                    if ((!packages || !dec.getQualifiedName().startsWith(name)) && (packages || !dec.getQualifiedName().equals(name))) continue;
                    this.removeAllTypes((JavaScriptType)this.cachedTypes.get(dec));
                    removeTypes.add(dec);
                }
            }
            this.cachedTypes.keySet().removeAll(removeTypes);
        }
    }

    public void clearAllImports() {
        this.importClasses.clear();
        this.importPackages.clear();
        HashSet<TypeDeclaration> removeTypes = new HashSet<TypeDeclaration>();
        for (TypeDeclaration dec : this.cachedTypes.keySet()) {
            if (TypeDeclarationFactory.Instance().isJavaScriptType(dec) || dec.equals(TypeDeclarationFactory.getDefaultTypeDeclaration())) continue;
            this.removeAllTypes((JavaScriptType)this.cachedTypes.get(dec));
            removeTypes.add(dec);
        }
        this.cachedTypes.keySet().removeAll(removeTypes);
    }

    private void removeAllTypes(JavaScriptType type) {
        if (type != null) {
            TypeDeclarationFactory.Instance().removeType(type.getType().getQualifiedName());
            if (type.getExtendedClasses().size() > 0) {
                for (JavaScriptType extendedType : type.getExtendedClasses()) {
                    this.removeAllTypes(extendedType);
                }
            }
        }
    }

    public ClassFile getClassFile(JarManager manager, TypeDeclaration type) {
        ClassFile file = super.getClassFile(manager, type);
        if (file == null && (file = this.findFromClasses(manager, type.getAPITypeName())) == null) {
            file = this.findFromImport(manager, type.getAPITypeName());
        }
        return file;
    }

    private ClassFile findFromClasses(JarManager manager, String name) {
        String cls;
        ClassFile file = null;
        Iterator i = this.importClasses.iterator();
        while (i.hasNext() && (!(cls = (String)i.next()).endsWith(name) || (file = manager.getClassEntry(cls)) == null)) {
        }
        return file;
    }

    private ClassFile findFromImport(JarManager manager, String name) {
        ClassFile file = null;
        for (String packageName : this.importPackages) {
            String cls = name.startsWith(".") ? packageName + name : packageName + "." + name;
            file = manager.getClassEntry(cls);
            if (file == null) continue;
            break;
        }
        return file;
    }
}

