/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.js;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.io.DocumentReader;
import org.fife.rsta.ac.js.JavaScriptLanguageSupport;
import org.fife.rsta.ac.js.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ErrorCollector;
import org.mozilla.javascript.ast.ParseProblem;

public class JavaScriptParser
extends AbstractParser {
    public static final String PROPERTY_AST = "AST";
    private AstRoot astRoot;
    private JavaScriptLanguageSupport langSupport;
    private PropertyChangeSupport support;
    private DefaultParseResult result;

    public JavaScriptParser(JavaScriptLanguageSupport langSupport, RSyntaxTextArea textArea) {
        this.langSupport = langSupport;
        this.support = new PropertyChangeSupport((Object)this);
        this.result = new DefaultParseResult((org.fife.ui.rsyntaxtextarea.parser.Parser)this);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.support.addPropertyChangeListener(prop, l);
    }

    public static CompilerEnvirons createCompilerEnvironment(ErrorReporter errorHandler, JavaScriptLanguageSupport langSupport) {
        CompilerEnvirons env = new CompilerEnvirons();
        env.setErrorReporter(errorHandler);
        env.setIdeMode(true);
        env.setRecordingComments(true);
        env.setRecordingLocalJsDocComments(true);
        env.setRecoverFromErrors(true);
        if (langSupport != null) {
            env.setXmlAvailable(langSupport.isXmlAvailable());
            env.setStrictMode(langSupport.isStrictMode());
            int version = langSupport.getLanguageVersion();
            if (version > 0) {
                Logger.log("[JavaScriptParser]: JS language version set to: " + version);
                env.setLanguageVersion(version);
            }
        }
        return env;
    }

    public AstRoot getAstRoot() {
        return this.astRoot;
    }

    public ParseResult parse(RSyntaxDocument doc, String style) {
        int len;
        int offs;
        this.astRoot = null;
        this.result.clearNotices();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        this.result.setParsedLines(0, lineCount - 1);
        DocumentReader r = new DocumentReader((Document)doc);
        ErrorCollector errorHandler = new ErrorCollector();
        CompilerEnvirons env = JavaScriptParser.createCompilerEnvironment((ErrorReporter)errorHandler, this.langSupport);
        long start = System.currentTimeMillis();
        try {
            Parser parser = new Parser(env);
            this.astRoot = parser.parse((Reader)r, null, 0);
            long time = System.currentTimeMillis() - start;
            this.result.setParseTime(time);
        }
        catch (IOException ioe) {
            this.result.setError((Exception)ioe);
            ioe.printStackTrace();
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            Element elem = root.getElement(line);
            offs = elem.getStartOffset();
            len = elem.getEndOffset() - offs - 1;
            String msg = re.details();
            this.result.addNotice((ParserNotice)new DefaultParserNotice((org.fife.ui.rsyntaxtextarea.parser.Parser)this, msg, line, offs, len));
        }
        catch (Exception e) {
            this.result.setError(e);
        }
        r.close();
        List errors = errorHandler.getErrors();
        if (errors != null && errors.size() > 0) {
            for (ParseProblem problem : errors) {
                offs = problem.getFileOffset();
                len = problem.getLength();
                int line = root.getElementIndex(offs);
                String desc = problem.getMessage();
                DefaultParserNotice notice = new DefaultParserNotice((org.fife.ui.rsyntaxtextarea.parser.Parser)this, desc, line, offs, len);
                if (problem.getType() == ParseProblem.Type.Warning) {
                    notice.setLevel(1);
                }
                this.result.addNotice((ParserNotice)notice);
            }
        }
        this.support.firePropertyChange(PROPERTY_AST, null, this.astRoot);
        return this.result;
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.support.removePropertyChangeListener(prop, l);
    }

    public static class JSErrorReporter
    implements ErrorReporter {
        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return null;
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        }
    }
}

