/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java.buildpath;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.classreader.ClassFile;

public class JarLibraryInfo
extends LibraryInfo {
    private File jarFile;

    public JarLibraryInfo(String jarFile) {
        this(new File(jarFile));
    }

    public JarLibraryInfo(File jarFile) {
        this(jarFile, null);
    }

    public JarLibraryInfo(File jarFile, SourceLocation sourceLoc) {
        this.setJarFile(jarFile);
        this.setSourceLocation(sourceLoc);
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        int result = -1;
        if (o instanceof JarLibraryInfo) {
            result = this.jarFile.compareTo(((JarLibraryInfo)o).jarFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile createClassFile(String entryName) throws IOException {
        JarFile jar = new JarFile(this.jarFile);
        try {
            JarEntry entry = (JarEntry)jar.getEntry(entryName);
            if (entry == null) {
                System.err.println("ERROR: Invalid entry: " + entryName);
                ClassFile classFile = null;
                return classFile;
            }
            DataInputStream in = new DataInputStream(new BufferedInputStream(jar.getInputStream(entry)));
            ClassFile cf = new ClassFile(in);
            in.close();
            ClassFile classFile = cf;
            return classFile;
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap createPackageMap() throws IOException {
        TreeMap packageMap = new TreeMap();
        JarFile jar = new JarFile(this.jarFile);
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                entryName = entryName.substring(0, entryName.length() - 6);
                String[] items = Util.splitOnChar(entryName, 47);
                TreeMap m = packageMap;
                for (int i = 0; i < items.length - 1; ++i) {
                    TreeMap submap = (TreeMap)m.get(items[i]);
                    if (submap == null) {
                        submap = new TreeMap();
                        m.put(items[i], submap);
                    }
                    m = submap;
                }
                String className = items[items.length - 1];
                m.put(className, null);
            }
        }
        finally {
            jar.close();
        }
        return packageMap;
    }

    public long getLastModified() {
        return this.jarFile.lastModified();
    }

    public String getLocationAsString() {
        return this.jarFile.getAbsolutePath();
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public int hashCode() {
        return this.jarFile.hashCode();
    }

    private void setJarFile(File jarFile) {
        if (jarFile == null || !jarFile.exists()) {
            String name = jarFile == null ? "null" : jarFile.getAbsolutePath();
            throw new IllegalArgumentException("Jar does not exist: " + name);
        }
        this.jarFile = jarFile;
    }

    public String toString() {
        return "[JarLibraryInfo: jar=" + this.jarFile.getAbsolutePath() + "; source=" + this.getSourceLocation() + "]";
    }
}

