/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.PackageNameCompletion;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.ui.autocomplete.CompletionProvider;

class JarReader {
    private LibraryInfo info;
    private TreeMap packageMap;
    private long lastModified;

    public JarReader(LibraryInfo info) throws IOException {
        this.info = info;
        this.packageMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.loadCompletions();
    }

    public void addCompletions(CompletionProvider provider, String[] pkgNames, Set addTo) {
        this.checkLastModified();
        TreeMap map = this.packageMap;
        for (int i = 0; i < pkgNames.length - 1; ++i) {
            Object obj = map.get(pkgNames[i]);
            if (!(obj instanceof TreeMap)) {
                return;
            }
            map = (TreeMap)obj;
        }
        String fromKey = pkgNames[pkgNames.length - 1];
        String toKey = fromKey + '{';
        SortedMap sm = map.subMap(fromKey, toKey);
        for (String obj : sm.keySet()) {
            Object value = sm.get(obj);
            if (value instanceof ClassFile) {
                ClassFile cf = (ClassFile)value;
                boolean inPkg = false;
                if (!inPkg && !org.fife.rsta.ac.java.classreader.Util.isPublic(cf.getAccessFlags())) continue;
                addTo.add(new ClassCompletion(provider, cf));
                continue;
            }
            String[] items = new String[pkgNames.length];
            System.arraycopy(pkgNames, 0, items, 0, pkgNames.length - 1);
            items[items.length - 1] = obj.toString();
            ClassFile cf = this.getClassEntry(items);
            if (cf != null) {
                boolean inPkg = false;
                if (!inPkg && !org.fife.rsta.ac.java.classreader.Util.isPublic(cf.getAccessFlags())) continue;
                addTo.add(new ClassCompletion(provider, cf));
                continue;
            }
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < pkgNames.length - 1; ++j) {
                sb.append(pkgNames[j]).append('.');
            }
            sb.append(obj.toString());
            String text = sb.toString();
            addTo.add(new PackageNameCompletion(provider, text, fromKey));
        }
    }

    private void checkLastModified() {
        long newLastModified = this.info.getLastModified();
        if (newLastModified != 0L && newLastModified != this.lastModified) {
            int count = 0;
            count = this.clearClassFiles(this.packageMap);
            System.out.println("DEBUG: Cleared " + count + " cached ClassFiles");
            this.lastModified = newLastModified;
        }
    }

    private int clearClassFiles(Map map) {
        int clearedCount = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof ClassFile) {
                entry.setValue(null);
                ++clearedCount;
                continue;
            }
            if (!(value instanceof Map)) continue;
            clearedCount += this.clearClassFiles((Map)value);
        }
        return clearedCount;
    }

    public boolean containsClass(String className) {
        String[] items = className.split("\\.");
        TreeMap m = this.packageMap;
        for (int i = 0; i < items.length - 1; ++i) {
            Object value = m.get(items[i]);
            if (!(value instanceof TreeMap)) {
                return false;
            }
            m = (TreeMap)value;
        }
        return m.containsKey(items[items.length - 1]);
    }

    public boolean containsPackage(String pkgName) {
        String[] items = Util.splitOnChar(pkgName, 46);
        TreeMap m = this.packageMap;
        for (int i = 0; i < items.length; ++i) {
            Object value = m.get(items[i]);
            if (!(value instanceof TreeMap)) {
                return false;
            }
            m = (TreeMap)value;
        }
        return true;
    }

    public ClassFile getClassEntry(String[] items) {
        Object value;
        SortedMap<String, ClassFile> map = this.packageMap;
        for (int i = 0; i < items.length - 1; ++i) {
            if (map.containsKey(items[i])) {
                value = map.get(items[i]);
                if (!(value instanceof SortedMap)) {
                    return null;
                }
            } else {
                return null;
            }
            map = (SortedMap)value;
        }
        String className = items[items.length - 1];
        if (map.containsKey(className)) {
            value = map.get(className);
            if (value instanceof Map) {
                return null;
            }
            if (value instanceof ClassFile) {
                ClassFile cf = (ClassFile)value;
                return cf;
            }
            try {
                StringBuffer name = new StringBuffer(items[0]);
                for (int i = 1; i < items.length; ++i) {
                    name.append('/').append(items[i]);
                }
                name.append(".class");
                ClassFile cf = this.info.createClassFile(name.toString());
                map.put(className, cf);
                return cf;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public void getClassesInPackage(List addTo, String[] pkgs, boolean inPkg) {
        SortedMap map = this.packageMap;
        for (int i = 0; i < pkgs.length; ++i) {
            Object value;
            if (map.containsKey(pkgs[i])) {
                value = map.get(pkgs[i]);
                if (!(value instanceof SortedMap)) {
                    return;
                }
            } else {
                return;
            }
            map = (SortedMap)value;
        }
        TreeMap newClassFiles = null;
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                StringBuffer name = new StringBuffer(pkgs[0]);
                for (int j = 1; j < pkgs.length; ++j) {
                    name.append('/').append(pkgs[j]);
                }
                name.append('/');
                name.append((String)entry.getKey()).append(".class");
                try {
                    ClassFile cf = this.info.createClassFile(name.toString());
                    if (newClassFiles == null) {
                        newClassFiles = new TreeMap();
                    }
                    newClassFiles.put(entry.getKey(), cf);
                    this.possiblyAddTo(addTo, cf, inPkg);
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    break;
                }
            }
            if (!(value instanceof ClassFile)) continue;
            this.possiblyAddTo(addTo, (ClassFile)value, inPkg);
        }
        if (newClassFiles != null) {
            map.putAll(newClassFiles);
        }
    }

    public List getClassesWithNamesStartingWith(String prefix) {
        ArrayList res = new ArrayList();
        String currentPkg = "";
        this.getClassesWithNamesStartingWithImpl(prefix, this.packageMap, currentPkg, res);
        return res;
    }

    private void getClassesWithNamesStartingWithImpl(String prefix, Map map, String currentPkg, List addTo) {
        int prefixLen = prefix.length();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.getClassesWithNamesStartingWithImpl(prefix, (Map)value, currentPkg + key + "/", addTo);
                continue;
            }
            String className = key;
            if (!className.regionMatches(true, 0, prefix, 0, prefixLen)) continue;
            if (value == null) {
                String fqClassName = currentPkg + className + ".class";
                try {
                    value = this.info.createClassFile(fqClassName);
                    entry.setValue(value);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (value == null) continue;
            addTo.add(value);
        }
    }

    public LibraryInfo getLibraryInfo() {
        return (LibraryInfo)this.info.clone();
    }

    public SortedMap getPackageEntry(String[] pkgs) {
        SortedMap map = this.packageMap;
        for (int i = 0; i < pkgs.length; ++i) {
            Object value;
            if (map.containsKey(pkgs[i])) {
                value = map.get(pkgs[i]);
                if (!(value instanceof SortedMap)) {
                    return null;
                }
            } else {
                return null;
            }
            map = (SortedMap)value;
        }
        return map;
    }

    private void loadCompletions() throws IOException {
        this.packageMap = this.info.createPackageMap();
        this.lastModified = this.info.getLastModified();
    }

    private void possiblyAddTo(Collection addTo, ClassFile cf, boolean inPkg) {
        if (inPkg || org.fife.rsta.ac.java.classreader.Util.isPublic(cf.getAccessFlags())) {
            addTo.add(cf);
        }
    }
}

