/*
 * Decompiled with CFR 0.152.
 */
package com.fierydevs.calldetection.sms;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.SmsMessage;
import com.fierydevs.calldetection.CallSmsDetector;
import com.fierydevs.calldetection.sms.SmsReceivedListener;

public class SmsReceiver
extends BroadcastReceiver {
    private static SmsReceivedListener mListener;

    @TargetApi(value=4)
    public void onReceive(Context context, Intent intent) {
        CallSmsDetector.startOutgoingSms(context);
        Bundle data = intent.getExtras();
        Object[] pdus = (Object[])data.get("pdus");
        for (int i = 0; i < pdus.length; ++i) {
            SmsMessage currentMessage = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
            String senderNum = currentMessage.getDisplayOriginatingAddress();
            String message = currentMessage.getDisplayMessageBody();
            long timestamp = currentMessage.getTimestampMillis();
            String contactName = CallSmsDetector.retrieveContactName(context, senderNum);
            mListener.onMessageReceived(senderNum, contactName, message, timestamp);
        }
    }

    public static void setSmsReceivedListener(SmsReceivedListener smsListener) {
        mListener = smsListener;
    }
}

