/*
 * Decompiled with CFR 0.152.
 */
package com.fierydevs.calldetection;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.provider.ContactsContract;
import com.fierydevs.calldetection.PermissionsActivity;
import com.fierydevs.calldetection.sms.SmsObserver;

public class CallSmsDetector {
    public static void startOutgoingSms(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.registerContentObserver(Uri.parse((String)"content://sms"), true, (ContentObserver)new SmsObserver(new Handler(), context));
    }

    public static String retrieveContactName(Context context, String number) {
        ContentResolver cr = context.getContentResolver();
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)number));
        Cursor cursor = cr.query(uri, new String[]{"display_name"}, null, null, null);
        String contactName = "";
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                contactName = cursor.getString(cursor.getColumnIndex("display_name"));
            }
            if (!cursor.isClosed()) {
                cursor.close();
            }
        }
        return contactName;
    }

    public static void askForPermissions(Context context) {
        Intent intent = new Intent(context, PermissionsActivity.class);
        context.startActivity(intent);
    }

    public static boolean isMyServiceRunning(Context context, Class<?> aClass) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo serviceInfo : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!aClass.getName().equals(serviceInfo.service.getClassName())) continue;
            return true;
        }
        return false;
    }
}

