/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.aop;

import com.fhs.core.trans.anno.TransSett;
import com.fhs.trans.service.impl.TransService;
import com.fhs.trans.utils.TransUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Aspect
public class TransMethodResultAop
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TransMethodResultAop.class);
    @Value(value="${easy-trans.is-enable-tile:false}")
    private Boolean isEnableTile;
    @Value(value="${easy-trans.is-enable-map-result:false}")
    private Boolean isEnableMapResult;
    @Autowired
    private TransService transService;

    @Around(value="@annotation(com.fhs.core.trans.anno.TransMethodResult)")
    public Object transResult(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = null;
        HashSet<String> includeFields = null;
        HashSet<String> excludeFields = null;
        proceed = joinPoint.proceed();
        Class<?> targetCls = joinPoint.getTarget().getClass();
        MethodSignature ms = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = targetCls.getDeclaredMethod(ms.getName(), ms.getParameterTypes());
        if (targetMethod.isAnnotationPresent(TransSett.class)) {
            TransSett transSett = targetMethod.getAnnotation(TransSett.class);
            if (transSett.include().length != 0) {
                includeFields = new HashSet<String>(Arrays.asList(transSett.include()));
            } else {
                excludeFields = new HashSet<String>(Arrays.asList(transSett.exclude()));
            }
        }
        try {
            return TransUtil.transOne(proceed, this.transService, this.isEnableTile, new ArrayList<Object>(), includeFields, excludeFields);
        }
        catch (Exception e) {
            log.error("\u7ffb\u8bd1\u9519\u8bef", (Throwable)e);
            return proceed;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isEnableMapResult.booleanValue()) {
            TransUtil.transResultMap = true;
        }
    }
}

