/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.common.utils;

import com.fhs.common.utils.CheckUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterUtils {
    public static String toString(Object obj, String defaultVal) {
        if (obj == null) {
            return defaultVal;
        }
        return obj.toString();
    }

    public static String toString(Object obj) {
        return ConverterUtils.toString(obj, "");
    }

    public static Integer toInt(Object obj, Integer defaultVal) {
        try {
            return obj != null ? Integer.parseInt(ConverterUtils.toString(obj, "0")) : defaultVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultVal;
        }
    }

    public static Integer toInt(Object obj) {
        return ConverterUtils.toInt(obj, 0);
    }

    public static Integer toInteger(Object obj) {
        return ConverterUtils.toInt(obj, 0);
    }

    public static Float toFloat(Object obj, float defaultVal) {
        return Float.valueOf(obj != null ? Float.parseFloat(ConverterUtils.toString(obj, "0")) : defaultVal);
    }

    public static Float toFloat(Object obj) {
        return ConverterUtils.toFloat(obj, 0.0f);
    }

    public static Long toLong(Object obj, long defaultVal) {
        return obj != null ? Long.parseLong(ConverterUtils.toString(obj)) : defaultVal;
    }

    public static Long toLong(Object obj) {
        return ConverterUtils.toLong(obj, 0L);
    }

    public static boolean toBoolean(Object obj) {
        if (CheckUtils.isNullOrEmpty(obj)) {
            return false;
        }
        return "true".equals(obj.toString());
    }

    public static Double toDouble(Object obj, Double defaultVal) {
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public static double toDouble(Object obj) {
        return ConverterUtils.toDouble(obj, 0.0);
    }

    public static List<Map<String, Object>> converterForMapList(List<Object> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object tempObj : list) {
            result.add((HashMap)tempObj);
        }
        return result;
    }

    public static int char2Int(char c) {
        return c - 96;
    }
}

