/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal;

import com.fernandocejas.frodo.internal.DebugLog;
import com.fernandocejas.frodo.internal.MessageBuilder;
import com.fernandocejas.frodo.internal.observable.ObservableInfo;

public class MessageManager {
    private final MessageBuilder messageBuilder;
    private final DebugLog debugLog;

    public MessageManager() {
        this(new MessageBuilder(), new DebugLog());
    }

    public MessageManager(MessageBuilder messageBuilder, DebugLog debugLog) {
        this.messageBuilder = messageBuilder;
        this.debugLog = debugLog;
    }

    private void printMessage(String tag, String message) {
        this.debugLog.log(tag, message);
    }

    public void printObservableInfo(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableInfoMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnSubscribe(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableOnSubscribeMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public <T> void printObservableOnNextWithValue(ObservableInfo observableInfo, T value) {
        String message = this.messageBuilder.buildObservableOnNextWithValueMessage(observableInfo, value);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnNext(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableOnNextMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnError(ObservableInfo observableInfo, Throwable throwable) {
        String message = this.messageBuilder.buildObservableOnErrorMessage(observableInfo, throwable.getMessage());
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnCompleted(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableOnCompletedMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnTerminate(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableOnTerminateMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnUnsubscribe(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableOnUnsubscribeMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printSubscriberOnStart(String subscriberName) {
        String message = this.messageBuilder.buildSubscriberOnStartMessage(subscriberName);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberOnNext(String subscriberName, Object value, String threadName) {
        String message = this.messageBuilder.buildSubscriberOnNextMessage(subscriberName, value, threadName);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberOnError(String subscriberName, String error, long executionTimeMillis, int receivedItems) {
        String itemTimeMessage = this.messageBuilder.buildSubscriberItemTimeMessage(subscriberName, executionTimeMillis, receivedItems);
        String onErrorMessage = this.messageBuilder.buildSubscriberOnErrorMessage(subscriberName, error);
        this.printMessage(subscriberName, itemTimeMessage);
        this.printMessage(subscriberName, onErrorMessage);
    }

    public void printSubscriberOnCompleted(String subscriberName, long executionTimeMillis, int receivedItems) {
        String itemTimeMessage = this.messageBuilder.buildSubscriberItemTimeMessage(subscriberName, executionTimeMillis, receivedItems);
        String onCompleteMessage = this.messageBuilder.buildSubscriberOnCompletedMessage(subscriberName);
        this.printMessage(subscriberName, itemTimeMessage);
        this.printMessage(subscriberName, onCompleteMessage);
    }

    public void printSubscriberRequestedItems(String subscriberName, long requestedItems) {
        String message = this.messageBuilder.buildSubscriberRequestedItemsMessage(subscriberName, requestedItems);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberUnsubscribe(String subscriberName) {
        String message = this.messageBuilder.buildSubscriberUnsubscribeMessage(subscriberName);
        this.printMessage(subscriberName, message);
    }

    public void printObservableItemTimeInfo(ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableItemTimeInfoMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableThreadInfo(ObservableInfo observableInfo) {
        if (observableInfo.getSubscribeOnThread().isPresent() || observableInfo.getObserveOnThread().isPresent()) {
            String message = this.messageBuilder.buildObservableThreadInfoMessage(observableInfo);
            this.printMessage(observableInfo.getClassSimpleName(), message);
        }
    }
}

