/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal.observable;

import com.fernandocejas.frodo.annotation.RxLogObservable;
import com.fernandocejas.frodo.internal.MessageManager;
import com.fernandocejas.frodo.internal.observable.LogEventsObservable;
import com.fernandocejas.frodo.internal.observable.LogEverythingObservable;
import com.fernandocejas.frodo.internal.observable.LogNothingObservable;
import com.fernandocejas.frodo.internal.observable.LogSchedulersObservable;
import com.fernandocejas.frodo.internal.observable.LogStreamObservable;
import com.fernandocejas.frodo.internal.observable.LoggableObservable;
import com.fernandocejas.frodo.internal.observable.ObservableInfo;
import com.fernandocejas.frodo.joinpoint.FrodoProceedingJoinPoint;
import java.lang.annotation.Annotation;

public class LoggableObservableFactory {
    private final FrodoProceedingJoinPoint joinPoint;
    private final MessageManager messageManager;
    private final ObservableInfo observableInfo;

    public LoggableObservableFactory(FrodoProceedingJoinPoint joinPoint, MessageManager messageManager, ObservableInfo observableInfo) {
        this.joinPoint = joinPoint;
        this.messageManager = messageManager;
        this.observableInfo = observableInfo;
    }

    LoggableObservable create(Annotation annotation) {
        Class observableType = this.joinPoint.getGenericReturnTypes().get(0);
        if (annotation != null) {
            switch (((RxLogObservable)annotation).value()) {
                case NOTHING: {
                    return new LogNothingObservable(this.joinPoint, this.messageManager, this.observableInfo);
                }
                case STREAM: {
                    return new LogStreamObservable(this.joinPoint, this.messageManager, this.observableInfo);
                }
                case SCHEDULERS: {
                    return new LogSchedulersObservable(this.joinPoint, this.messageManager, this.observableInfo);
                }
                case EVENTS: {
                    return new LogEventsObservable(this.joinPoint, this.messageManager, this.observableInfo);
                }
            }
            return new LogEverythingObservable(this.joinPoint, this.messageManager, this.observableInfo);
        }
        return new LogNothingObservable(this.joinPoint, this.messageManager, this.observableInfo);
    }
}

