/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal;

import com.fernandocejas.frodo.internal.DebugLog;
import com.fernandocejas.frodo.internal.FrodoObservable;
import com.fernandocejas.frodo.internal.MessageBuilder;

public class MessageManager {
    private final MessageBuilder messageBuilder;
    private final DebugLog debugLog;

    public MessageManager() {
        this(new MessageBuilder(), new DebugLog());
    }

    public MessageManager(MessageBuilder messageBuilder, DebugLog debugLog) {
        this.messageBuilder = messageBuilder;
        this.debugLog = debugLog;
    }

    private void printMessage(String tag, String message) {
        this.debugLog.log(tag, message);
    }

    public void printObservableInfo(FrodoObservable.ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableInfoMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnSubscribe(FrodoObservable.ObservableInfo observableInfo, String threadName) {
        String message = this.messageBuilder.buildObservableOnSubscribeMessage(observableInfo, threadName);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public <T> void printObservableOnNext(FrodoObservable.ObservableInfo observableInfo, T value) {
        String message = this.messageBuilder.buildObservableOnNextMessage(observableInfo, value);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnError(FrodoObservable.ObservableInfo observableInfo, Throwable throwable) {
        String message = this.messageBuilder.buildObservableOnErrorMessage(observableInfo, throwable.getMessage());
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnCompleted(FrodoObservable.ObservableInfo observableInfo) {
        String message = this.messageBuilder.buildObservableOnCompletedMessage(observableInfo);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnTerminate(FrodoObservable.ObservableInfo observableInfo, long executionTimeMillis, int emittedElements) {
        String message = this.messageBuilder.buildObservableOnTerminateMessage(observableInfo, String.valueOf(executionTimeMillis), emittedElements);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printObservableOnUnsubscribe(FrodoObservable.ObservableInfo observableInfo, String threadName) {
        String message = this.messageBuilder.buildObservableOnUnsubscribeMessage(observableInfo, threadName);
        this.printMessage(observableInfo.getClassSimpleName(), message);
    }

    public void printSubscriberOnStart(String subscriberName) {
        String message = this.messageBuilder.buildSubscriberOnStartMessage(subscriberName);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberOnNext(String subscriberName, String value, String threadName) {
        String message = this.messageBuilder.buildSubscriberOnNextMessage(subscriberName, value, threadName);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberOnError(String subscriberName, String error, long executionTimeMillis, int receivedItems) {
        String message = this.messageBuilder.buildSubscriberOnErrorMessage(subscriberName, error, executionTimeMillis, receivedItems);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberOnCompleted(String subscriberName, long executionTimeMillis, int receivedItems) {
        String message = this.messageBuilder.buildSubscriberOnCompletedMessage(subscriberName, executionTimeMillis, receivedItems);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberRequestedItems(String subscriberName, long requestedItems) {
        String message = this.messageBuilder.buildSubscriberRequestedItemsMessage(subscriberName, requestedItems);
        this.printMessage(subscriberName, message);
    }

    public void printSubscriberUnsubscribe(String subscriberName) {
        String message = this.messageBuilder.buildSubscriberUnsubscribeMessage(subscriberName);
        this.printMessage(subscriberName, message);
    }
}

