/*
 * Decompiled with CFR 0.152.
 */
package com.feelschaotic.crypto.crypto;

import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

class RSAUtil {
    public static final String KEY_ALGORITHM_RSA = "RSA";
    private static String RSA_JAVA = "RSA/ECB/PKCS1Padding";
    private static final String RSA_PUBLIC_KEY = "RSAPublicKey";
    private static final String RSA_PRIVATE_KEY = "RSAPrivateKey";
    private static final int KEY_SIZE = 1024;

    RSAUtil() {
    }

    public static byte[] decryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(2, privateKey);
        int blockSize = cipher.getBlockSize();
        if (blockSize > 0) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
            int j = 0;
            while (data.length - j * blockSize > 0) {
                bout.write(cipher.doFinal(data, j * blockSize, blockSize));
                ++j;
            }
            return bout.toByteArray();
        }
        return cipher.doFinal(data);
    }

    public static String decryptByPrivateKey(String base64Data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(2, privateKey);
        int blockSize = cipher.getBlockSize();
        byte[] data = Base64.decode((String)base64Data, (int)2);
        if (blockSize > 0) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
            int j = 0;
            while (data.length - j * blockSize > 0) {
                bout.write(cipher.doFinal(data, j * blockSize, blockSize));
                ++j;
            }
            return new String(bout.toByteArray());
        }
        return new String(cipher.doFinal(data));
    }

    public static byte[] decryptByPublicKey(byte[] data, byte[] key) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(String base64Data, String key) throws Exception {
        byte[] data = Base64.decode((String)base64Data, (int)2);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decode((String)key, (int)2));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] key) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(1, publicKey);
        int blockSize = cipher.getBlockSize();
        byte[] raw = RSAUtil.getBytes(data, cipher, blockSize);
        if (raw != null) {
            return raw;
        }
        return cipher.doFinal(data);
    }

    public static String encryptByPublicKey(String data, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(1, publicKey);
        int blockSize = cipher.getBlockSize();
        byte[] raw = RSAUtil.getBytes(data.getBytes(), cipher, blockSize);
        if (raw != null) {
            return Base64.encodeToString((byte[])raw, (int)2);
        }
        return Base64.encodeToString((byte[])cipher.doFinal(data.getBytes()), (int)2);
    }

    private static byte[] getBytes(byte[] data, Cipher cipher, int blockSize) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (blockSize > 0) {
            int outputSize = cipher.getOutputSize(data.length);
            int leavedSize = data.length % blockSize;
            int blocksSize = leavedSize != 0 ? data.length / blockSize + 1 : data.length / blockSize;
            byte[] raw = new byte[outputSize * blocksSize];
            int i = 0;
            int remainSize = 0;
            while ((remainSize = data.length - i * blockSize) > 0) {
                int inputLen = remainSize > blockSize ? blockSize : remainSize;
                cipher.doFinal(data, i * blockSize, inputLen, raw, i * outputSize);
                ++i;
            }
            return raw;
        }
        return null;
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(RSA_JAVA);
        cipher.init(1, privateKey);
        int blockSize = cipher.getBlockSize();
        byte[] raw = RSAUtil.getBytes(data, cipher, blockSize);
        return cipher.doFinal(data);
    }

    public static Key getPrivateKey(Map<String, Key> keyMap) throws Exception {
        return keyMap.get(RSA_PRIVATE_KEY);
    }

    public static byte[] getPrivateKeyByte(Map<String, Key> keyMap) throws Exception {
        return keyMap.get(RSA_PRIVATE_KEY).getEncoded();
    }

    public static Key getPublicKey(Map<String, Key> keyMap) throws Exception {
        return keyMap.get(RSA_PUBLIC_KEY);
    }

    public static byte[] getPublicKeyByte(Map<String, Key> keyMap) throws Exception {
        return keyMap.get(RSA_PUBLIC_KEY).getEncoded();
    }

    public static Map<String, Key> initKey(byte[] seed) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA);
        keyPairGen.initialize(1024, new SecureRandom(seed));
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Key> keyMap = new HashMap<String, Key>(2);
        keyMap.put(RSA_PUBLIC_KEY, publicKey);
        keyMap.put(RSA_PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static Map<String, Key> initKey(String seed) throws Exception {
        return RSAUtil.initKey(seed.getBytes());
    }

    public static Map<String, Key> initKey() throws Exception {
        return RSAUtil.initKey(UUID.randomUUID().toString().getBytes());
    }

    public static PublicKey getPublicRSAKey(String key) throws Exception {
        X509EncodedKeySpec x509 = new X509EncodedKeySpec(Base64.decode((String)key, (int)2));
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        return kf.generatePublic(x509);
    }

    public static PrivateKey getPrivateRSAKey(String key) throws Exception {
        PKCS8EncodedKeySpec pkgs8 = new PKCS8EncodedKeySpec(Base64.decode((String)key, (int)2));
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        return kf.generatePrivate(pkgs8);
    }
}

