package com.feelschaotic.crypto.crypto;

import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;


public class AESUtil {

    private static final String IV_SPEC = "2018062612345678";
    private static final String ALGORITHM_NAME = "AES";
    public static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    public static final byte[] TEMPLATE_KEY = {100, 111, 117, 110, 105, 119, 97, 110, 100, 111, 117, 110, 105, 119, 97, 110};
    public static final byte[] TEMPLATE_KEY2 = {97, 111, 119, 54, 112, 119, 97, 110, 25, 113, 117, 117, 105, 120, 97, 110};
    public static final String aesKey = "YW93NnB3YW4ZcXV1aXhhbg==";
    public static byte[] templateKeyAesKey;

    /**
     * ʹAES 
     *
     * @param content   ַܺ
     * @param secretKey Կ
     * @return ַܺ
     */
    public static String decryptByAes(String content, String secretKey) throws Exception {
        byte[] decryptContent = Base64.decode(content, Base64.NO_WRAP);
        byte[] result = decryptByAes(decryptContent, getKey(secretKey));
        return new String(result != null ? result : new byte[0]);
    }

    private static byte[] getKey(String strKey) {
        byte[] arrBTmp = strKey.getBytes();
        byte[] arrB = new byte[16]; // һյ16λֽ飨ĬֵΪ0

        for (int i = 0; i < arrBTmp.length && i < arrB.length; i++) {
            arrB[i] = arrBTmp[i];
        }
        return arrB;
    }

    /**
     * ʹAES 
     *
     * @param content   ܺbyte
     * @param secretKey Կ
     * @return ܺbyte
     */
    public static byte[] decryptByAes(byte[] content, byte[] secretKey) throws Exception {
        Key keySpec = new SecretKeySpec(secretKey, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(IV_SPEC.getBytes());
        Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
        cipher.init(Cipher.DECRYPT_MODE, keySpec, ivParameterSpec);
        return cipher.doFinal(content);
    }

    /**
     * ʹAES byte
     *
     * @param content   
     * @param secretKey Կ
     * @return ܺ
     */
    public static String encrypt(String content, String secretKey) {
        byte[] result = encrypt(content.getBytes(), getKey(secretKey));
        return Base64.encodeToString(result, Base64.NO_WRAP);
    }

    /**
     * ʹAES byte
     *
     * @param content   
     * @param secretKey Կ
     * @return ܺ
     */
    public static byte[] encrypt(byte[] content, byte[] secretKey) {
        try {
            Key keySpec = new SecretKeySpec(secretKey, ALGORITHM_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(IV_SPEC.getBytes());
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, ivParameterSpec);
            return cipher.doFinal(content);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    public static String decodeScript(String base64String) {
        String result = "";
        try {
            byte[] decryptContent = Base64.decode(base64String, Base64.DEFAULT);
            Key keySpec = new SecretKeySpec(getTemplateKeyAesKey(), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec("2624750074598718".getBytes());
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(Cipher.DECRYPT_MODE, keySpec, ivParameterSpec);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
            cipherOutputStream.write(decryptContent);
            cipherOutputStream.flush();
            byteArrayOutputStream.flush();
            cipher.doFinal();
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            result = remove0(byteArray);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String decodeScript(byte[] bytes) {
        String result = "";
        try {
            Key keySpec = new SecretKeySpec(getTemplateKeyAesKey(), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec("2624750074598718".getBytes());
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(Cipher.DECRYPT_MODE, keySpec, ivParameterSpec);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
            cipherOutputStream.write(bytes);
            cipherOutputStream.flush();
            byteArrayOutputStream.flush();
            cipher.doFinal();
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            result = remove0(byteArray);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }


    public static byte[] getTemplateKeyAesKey() {
        if (null == templateKeyAesKey) {
            templateKeyAesKey = Base64.decode(aesKey, Base64.NO_WRAP);
            for (int i = 0; i < templateKeyAesKey.length; i++) {
                if (i == 0) {
                    templateKeyAesKey[6] = templateKeyAesKey[i];
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[i] + 3);
                }

                if (i == 2) {
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[i] - 2);
                }

                if (i == 3) {
                    templateKeyAesKey[i] = (byte) ((templateKeyAesKey[i] << 1) + 2);
                }

                if (i == 4) {
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[2] - 12);
                }

                if (i == 8) {
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[i] << 2);
                }

                if (i == 9) {
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[i] - 2);
                }

                if (i == 11) {
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[i] - 7);
                }

                if (i == 13) {
                    templateKeyAesKey[i] = (byte) (templateKeyAesKey[i] - 1);
                }
            }
        }
        return templateKeyAesKey;
    }

    private static String remove0(byte[] buffer) {
        int length = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) {
                length = i;
                break;
            }
        }
        String result = new String(buffer, 0, length);
        return result;
    }
}
