/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESHelper {
    private static Logger logger = LoggerFactory.getLogger(AESHelper.class);

    public static String encrypt(String c, String key) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(Hex.decodeHex((char[])key.toCharArray()), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            byte[] encoded = cipher.doFinal(c.getBytes());
            return new String(Hex.encodeHex((byte[])encoded));
        }
        catch (Exception e) {
            logger.warn("Could not encrypt string", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(byte[] c, String key) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(Hex.decodeHex((char[])key.toCharArray()), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
            byte[] encoded = cipher.doFinal(c);
            return new String(Hex.encodeHex((byte[])encoded));
        }
        catch (Exception e) {
            logger.warn("Could not encrypt byte[]", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String c, String key) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(Hex.decodeHex((char[])key.toCharArray()), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeySpec);
            byte[] decoded = cipher.doFinal(Hex.decodeHex((char[])c.toCharArray()));
            return new String(decoded);
        }
        catch (Exception e) {
            logger.warn("Could not decrypt string", (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] c, String key) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(Hex.decodeHex((char[])key.toCharArray()), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skeySpec);
            return cipher.doFinal(Hex.decodeHex((char[])new String(c).toCharArray()));
        }
        catch (Exception e) {
            logger.warn("Could not decrypt byte[]", (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptFile(String path, String key) {
        try {
            byte[] buf = AESHelper.readFile(path);
            return AESHelper.decrypt(buf, key);
        }
        catch (Exception e) {
            logger.warn("Could not decrypt file {}", (Object)path, (Object)e);
            return null;
        }
    }

    public static void encryptToFile(String path, byte[] buf, String key) {
        try {
            Files.write(Paths.get(path, new String[0]), AESHelper.encrypt(buf, key).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.warn("Could not encrypt to file {}", (Object)path, (Object)e);
        }
    }

    public static byte[] readFile(String filePath) throws IOException {
        return Files.readAllBytes(Paths.get(filePath, new String[0]));
    }
}

