/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.pool;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseFactory;
import com.feedzai.commons.sql.abstraction.engine.pool.PooledDatabaseEngine;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PooledDatabaseEngineFactory
extends BasePooledObjectFactory<PooledDatabaseEngine> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledDatabaseEngineFactory.class);
    private GenericObjectPool<PooledDatabaseEngine> pool;
    private final Properties properties;
    private final Consumer<DatabaseEngine> engineModifier;

    PooledDatabaseEngineFactory(Map<String, String> propertiesMap, Consumer<DatabaseEngine> engineModifier) {
        this.engineModifier = engineModifier;
        this.properties = new Properties();
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            this.properties.setProperty(entry.getKey(), entry.getValue() == null ? "" : entry.getValue());
        }
    }

    public PooledDatabaseEngine create() throws Exception {
        DatabaseEngine engine = DatabaseFactory.getConnection(this.properties);
        if (this.engineModifier != null) {
            this.engineModifier.accept(engine);
        }
        return new PooledDatabaseEngine(this.pool, engine);
    }

    public boolean validateObject(PooledObject<PooledDatabaseEngine> pooled) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Validating PooledDatabaseEngine " + pooled);
        }
        return ((PooledDatabaseEngine)pooled.getObject()).checkConnection(true);
    }

    public PooledObject<PooledDatabaseEngine> wrap(PooledDatabaseEngine engine) {
        DefaultPooledObject pooledEngine = new DefaultPooledObject((Object)engine);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating and Wrapping PooledDatabaseEngine  " + pooledEngine);
        }
        return pooledEngine;
    }

    public void destroyObject(PooledObject<PooledDatabaseEngine> p) {
        PooledDatabaseEngine engine;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Destroying PooledDatabaseEngine " + p);
        }
        if ((engine = (PooledDatabaseEngine)p.getObject()) != null) {
            engine.closeConnection();
        }
    }

    public void activateObject(PooledObject<PooledDatabaseEngine> p) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Activating PooledDatabaseEngine " + p);
        }
        ((PooledDatabaseEngine)p.getObject()).checkConnection(true);
    }

    GenericObjectPool<PooledDatabaseEngine> getPool() {
        return this.pool;
    }

    void setPool(GenericObjectPool<PooledDatabaseEngine> pool) {
        this.pool = pool;
    }
}

