/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml.result;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class ResultColumn
implements Serializable {
    protected final Object val;
    protected final String name;

    public ResultColumn(String name, Object val) {
        this.name = name;
        this.val = this.processObject(val);
    }

    protected Object processObject(Object o) {
        return o;
    }

    public boolean isNull() {
        return this.val == null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.val instanceof Clob) {
            return this.getStringFromClob((Clob)this.val);
        }
        return this.val.toString();
    }

    public Integer toInt() {
        if (this.isNull()) {
            return null;
        }
        return (int)Double.parseDouble(this.val.toString());
    }

    public Double toDouble() {
        if (this.isNull()) {
            return null;
        }
        return Double.parseDouble(this.val.toString());
    }

    public Float toFloat() {
        if (this.isNull()) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(this.val.toString()));
    }

    public Long toLong() {
        if (this.isNull()) {
            return null;
        }
        try {
            return Long.parseLong(this.val.toString());
        }
        catch (NumberFormatException e) {
            return (long)Double.parseDouble(this.val.toString());
        }
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.val;
    }

    public Boolean toBoolean() {
        if (this.isNull()) {
            return null;
        }
        return (Boolean)this.val;
    }

    public <T> T toBlob() throws DatabaseEngineRuntimeException {
        InputStream is;
        if (this.isNull()) {
            return null;
        }
        if (this.val instanceof Blob) {
            try {
                is = ((Blob)this.val).getBinaryStream();
            }
            catch (SQLException e) {
                throw new DatabaseEngineRuntimeException("Error getting blob input stream", e);
            }
        } else if (this.val instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])this.val);
        } else {
            throw new DatabaseEngineRuntimeException("Column is not a Blob neither a byte[]");
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new DatabaseEngineRuntimeException("Error converting blob to object", e);
        }
    }

    private String getStringFromClob(Clob clob) {
        try {
            int read;
            Reader reader = clob.getCharacterStream();
            char[] buff = new char[512];
            StringBuilder result = new StringBuilder();
            while ((read = reader.read(buff)) != -1) {
                result.append(buff, 0, read);
            }
            return result.toString();
        }
        catch (Exception ex) {
            throw new DatabaseEngineRuntimeException("Unable to get string from clob", ex);
        }
    }
}

