/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.util;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;

public class TypeTranslationUtils {
    public static String translateH2Type(DbColumn c, PdbProperties properties) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case INT: {
                if (c.isAutoInc()) {
                    return "INTEGER AUTO_INCREMENT";
                }
                return "INTEGER";
            }
            case LONG: {
                if (c.isAutoInc()) {
                    return "IDENTITY";
                }
                return "BIGINT";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.varchar_size"));
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "CLOB";
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    public static String translateOracleType(DbColumn c, PdbProperties properties) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return String.format("char %s check (%s in ('0', '1'))", c.isDefaultValueSet() ? "DEFAULT " + c.getDefaultValue().translateOracle(properties) : "", StringUtil.quotize(c.getName()));
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "NUMBER(19,0)";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: {
                return "CLOB";
            }
            case BLOB: {
                return "BLOB";
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    public static String translateSqlServerType(DbColumn c, PdbProperties properties) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return "BIT";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "BIGINT";
            }
            case STRING: {
                return String.format("NVARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: {
                return "NVARCHAR(MAX)";
            }
            case BLOB: {
                if (properties.isMaxBlobSizeSet()) {
                    return String.format("VARBINARY(%s)", properties.getProperty("pdb.max_blob_size"));
                }
                return String.format("VARBINARY(MAX)", new Object[0]);
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    public static String translateMySqlType(DbColumn c, PdbProperties properties) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "BIGINT";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: {
                return "LONGTEXT";
            }
            case BLOB: {
                return String.format("LONGBLOB", new Object[0]);
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    public static String translatePostgreSqlType(DbColumn c, PdbProperties properties) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                if (c.isAutoInc()) {
                    return "SERIAL";
                }
                return "INT";
            }
            case LONG: {
                if (c.isAutoInc()) {
                    return "BIGSERIAL";
                }
                return "BIGINT";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: {
                return "TEXT";
            }
            case BLOB: {
                return String.format("BYTEA", new Object[0]);
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    public static String translateDB2Type(DbColumn c, PdbProperties properties) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return String.format("char check (%s in ('0', '1'))", StringUtil.quotize(c.getName()));
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "NUMERIC(19,0)";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.varchar_size"));
            }
            case BLOB: 
            case CLOB: {
                if (properties.isMaxBlobSizeSet()) {
                    return String.format("BLOB(%s)", c.isSizeSet() ? c.getSize().toString() : properties.getProperty("pdb.max_blob_size"));
                }
                return String.format("BLOB(%s)", "2G");
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }
}

