/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public final class StringUtil {
    private StringUtil() {
    }

    public static String escapeSql(String s) {
        return StringEscapeUtils.escapeSql((String)s);
    }

    public static String stripToNull(String s) {
        return StringUtils.stripToNull((String)s);
    }

    public static Boolean isBlank(String s) {
        return StringUtils.isBlank((String)s);
    }

    public static Boolean isEmpty(String s) {
        return StringUtils.isEmpty((String)s);
    }

    public static String quotize(String s) {
        return "\"" + s + "\"";
    }

    public static String quotize(String s, String quoteChar) {
        return quoteChar + s + quoteChar;
    }

    public static String singleQuotize(String s) {
        return "'" + s + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream stream) throws IOException {
        InputStreamReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            int got;
            br = new InputStreamReader(stream);
            while ((got = br.read()) != -1) {
                sb.append((char)got);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static <T> String join(Collection<T> collection) {
        return StringUtil.join(collection, "");
    }

    public static <T> String join(Collection<T> collection, String separator) {
        StringBuilder builder = new StringBuilder();
        if (separator == null) {
            separator = "";
        }
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }
}

