/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.OracleResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineImpl;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.MathUtil;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import com.feedzai.commons.sql.abstraction.util.TypeTranslationUtils;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.OraclePreparedStatement;

public class OracleEngine
extends DatabaseEngineImpl {
    protected static final String ORACLE_DRIVER = DatabaseEngineDriver.ORACLE.driver();
    public static final String NAME_ALREADY_EXISTS = "ORA-00955";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "ORA-02260";
    public static final String SEQUENCE_DOES_NOT_EXIST = "ORA-02289";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "ORA-00942";
    public static final String FOREIGN_ALREADY_EXISTS = "ORA-02275";

    public OracleEngine(Properties properties) throws DatabaseEngineException {
        super(ORACLE_DRIVER, properties, Dialect.ORACLE);
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            StringReader sr = new StringReader((String)val);
                            ps.setClob(i, sr);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, "1");
                            break;
                        }
                        ps.setObject(i, "0");
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    @Override
    protected void setTransactionIsolation() throws SQLException {
        int isolation = this.properties.getIsolationLevel();
        if (isolation == 1) {
            isolation = 2;
        }
        if (isolation == 4) {
            isolation = 8;
        }
        this.conn.setTransactionIsolation(isolation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block16: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtil.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtil.quotize(c.getName()));
                column.add(this.translateType(c));
                if (c.isDefaultValueSet() && !c.getDbColumnType().equals((Object)DbColumnType.BOOLEAN)) {
                    column.add("DEFAULT");
                    column.add(c.getDefaultValue().translateOracle(this.properties));
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                columns.add(StringUtil.join(column, " "));
            }
            createTable.add("(" + StringUtil.join(columns, ", ") + ")");
            createTable.add("SEGMENT CREATION IMMEDIATE");
            String createTableStatement = StringUtil.join(createTable, " ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    break block16;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block15: {
            if (entity.getPkFields().length == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtil.quotize(pk));
            }
            String pkName = MathUtil.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtil.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtil.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + StringUtil.join(pks, ", ") + ")");
            String addPrimaryKey = StringUtil.join(statement, " ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY)) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    break block15;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtil.quotize(column));
                columnsForName.add(column);
            }
            String idxName = MathUtil.md5(String.format("%s_%s_IDX", entity.getName(), StringUtil.join(columnsForName, "_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtil.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtil.quotize(entity.getName()));
            createIndex.add("(" + StringUtil.join(columns, ", ") + ")");
            String statement = StringUtil.join(createIndex, " ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = MathUtil.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> createSequence = new ArrayList<String>();
            createSequence.add("CREATE SEQUENCE ");
            createSequence.add(StringUtil.quotize(sequenceName));
            createSequence.add("MINVALUE 1");
            createSequence.add("MAXVALUE");
            switch (column.getDbColumnType()) {
                case INT: {
                    createSequence.add(String.format("%d", Integer.MAX_VALUE));
                    break;
                }
                case LONG: {
                    createSequence.add(String.format("%d", Long.MAX_VALUE));
                    break;
                }
                default: {
                    throw new DatabaseEngineException("Auto incrementation is only supported on INT and LONG");
                }
            }
            createSequence.add("START WITH 1");
            createSequence.add("INCREMENT BY 1");
            String statement = StringUtil.join(createSequence, " ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)sequenceName);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtil.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtil.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String returning = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtil.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            columns.add(StringUtil.quotize(column.getName()));
            if (column.isAutoInc()) {
                String sequenceName = MathUtil.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
                values.add(String.format("%s.nextval", StringUtil.quotize(sequenceName)));
                returning = column.getName();
                continue;
            }
            values.add("?");
        }
        insertInto.add("(" + StringUtil.join(columns, ", ") + ")");
        insertInto.add("VALUES (" + StringUtil.join(values, ", ") + ")");
        insertIntoWithAutoInc.add("(" + StringUtil.join(columnsWithAutoInc, ", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + StringUtil.join(valuesWithAutoInc, ", ") + ")");
        ArrayList<String> insertIntoReturn = new ArrayList<String>(insertInto);
        if (returning != null) {
            insertIntoReturn.add(String.format("RETURNING %s INTO ?", StringUtil.quotize(returning)));
        } else {
            insertIntoReturn.add("RETURNING 0 INTO ?");
        }
        String insertStatement = StringUtil.join(insertInto, " ");
        String insertReturnStatement = StringUtil.join(insertIntoReturn, " ");
        String insertWithAutoInc = StringUtil.join(insertIntoWithAutoInc, " ");
        this.logger.trace(insertStatement);
        this.logger.trace(insertReturnStatement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(insertStatement);
            PreparedStatement psReturn = this.conn.prepareStatement(insertReturnStatement);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(insertWithAutoInc);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(returning);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = MathUtil.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            String stmt = String.format("DROP SEQUENCE %s", StringUtil.quotize(sequenceName));
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                this.logger.trace(stmt);
                drop.executeUpdate(stmt);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(SEQUENCE_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Sequence '{}' does not exist", (Object)sequenceName);
                    continue;
                }
                throw new DatabaseEngineException("Error dropping sequence", ex);
            }
            finally {
                try {
                    if (drop == null) continue;
                    drop.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s CASCADE CONSTRAINTS", StringUtil.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtil.quotize(entity.getName()));
            removeColumns.add("DROP");
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : columns) {
                cols.add(StringUtil.quotize(col));
            }
            removeColumns.add("( " + StringUtil.join(cols, ",") + " )");
            try {
                drop = this.conn.createStatement();
                String query = StringUtil.join(removeColumns, " ");
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtil.quotize(entity.getName()));
        addColumns.add("ADD");
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add(StringUtil.quotize(c.getName()));
            column.add(this.translateType(c));
            if (c.isDefaultValueSet() && !c.getDbColumnType().equals((Object)DbColumnType.BOOLEAN)) {
                column.add("DEFAULT");
                column.add(c.getDefaultValue().translateOracle(this.properties));
            }
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            cols.add(StringUtil.join(column, " "));
        }
        addColumns.add("( " + StringUtil.join(cols, ",") + " )");
        String addColumnsStatement = StringUtil.join(addColumns, " ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String translateType(DbColumn c) throws DatabaseEngineException {
        return TypeTranslationUtils.translateOracleType(c, this.properties);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry) throws DatabaseEngineException {
        return this.persist(name, entry, true);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        ResultSet generatedKeys = null;
        try {
            this.getConnection();
            MappedEntity me = (MappedEntity)this.entities.get(name);
            if (me == null) {
                throw new DatabaseEngineException(String.format("Unknown entity '%s'", name));
            }
            PreparedStatement ps = null;
            ps = useAutoInc ? me.getInsertReturning() : me.getInsertWithAutoInc();
            int i = this.entityToPreparedStatement(me.getEntity(), ps, entry, useAutoInc);
            if (useAutoInc) {
                ((OraclePreparedStatement)ps).registerReturnParameter(i + 1, 2);
            }
            ps.execute();
            long ret = 0L;
            if (useAutoInc) {
                generatedKeys = ((OraclePreparedStatement)ps).getReturnResultSet();
                if (generatedKeys.next()) {
                    ret = generatedKeys.getLong(1);
                }
                generatedKeys.close();
            } else {
                String sequenceName = MathUtil.md5(String.format("%s_%s_SEQ", name, me.getAutoIncColumn()), this.properties.getMaxIdentifierSize());
                String sql = "select (select max(\"" + me.getAutoIncColumn() + "\") from \"" + name + "\") - \"" + sequenceName + "\".NEXTVAL FROM dual";
                generatedKeys = this.getConnection().createStatement().executeQuery(sql);
                if (generatedKeys.next() && (ret = generatedKeys.getLong(1)) != 0L) {
                    this.getConnection().createStatement().executeQuery("ALTER SEQUENCE \"" + sequenceName + "\" INCREMENT BY " + ret);
                    this.getConnection().createStatement().executeQuery("SELECT \"" + sequenceName + "\".NEXTVAL FROM DUAL");
                    this.getConnection().createStatement().executeQuery("ALTER SEQUENCE \"" + sequenceName + "\" INCREMENT BY 1");
                }
            }
            Long l = ret == 0L ? null : Long.valueOf(ret);
            return l;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DatabaseEngineException("Something went wrong persisting the entity", ex);
        }
        finally {
            try {
                if (generatedKeys != null) {
                    generatedKeys.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing result set.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String s : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtil.quotize(s));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtil.quotize(s));
            }
            String table = StringUtil.quotize(entity.getName());
            String quotizedLocalColumnsSting = StringUtil.join(quotizedLocalColumns, ", ");
            String quotizedForeignColumnsString = StringUtil.join(quotizedForeignColumns, ", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", table, StringUtil.quotize(MathUtil.md5("FK_" + table + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtil.quotize(fk.getForeignTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(FOREIGN_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getMessage());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getMessage()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1 from dual");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String name) throws DatabaseEngineException {
        Map<String, DbColumnType> metaMap = super.getMetadata(name);
        Statement s = null;
        ResultSet rsColumns = null;
        try {
            Object dataPrecision;
            this.getConnection();
            s = this.conn.createStatement();
            rsColumns = s.executeQuery(String.format("SELECT COLUMN_NAME, DATA_TYPE, DATA_PRECISION FROM ALL_TAB_COLS WHERE TABLE_NAME = '%s' AND OWNER = UPPER('%s')", name, this.properties.getProperty("pdb.username")));
            while (rsColumns.next()) {
                dataPrecision = rsColumns.getString("DATA_PRECISION");
                DbColumnType value = this.toPdbType(dataPrecision == null ? rsColumns.getString("DATA_TYPE") : rsColumns.getString("DATA_TYPE") + (String)dataPrecision);
                if (value == DbColumnType.UNMAPPED) continue;
                metaMap.put(rsColumns.getString("COLUMN_NAME"), value);
            }
            dataPrecision = metaMap;
            return dataPrecision;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing statement.", (Throwable)a);
            }
        }
    }

    private DbColumnType toPdbType(String type) {
        if (type.equals("NUMBER")) {
            return DbColumnType.INT;
        }
        if (type.equals("CHAR")) {
            return DbColumnType.BOOLEAN;
        }
        if (type.equals("FLOAT126")) {
            return DbColumnType.DOUBLE;
        }
        if (type.equals("NUMBER19")) {
            return DbColumnType.LONG;
        }
        return DbColumnType.UNMAPPED;
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new OracleResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new OracleResultIterator(ps);
    }
}

