/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.MySqlResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineImpl;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.MathUtil;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import com.feedzai.commons.sql.abstraction.util.TypeTranslationUtils;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class MySqlEngine
extends DatabaseEngineImpl {
    public static final String ESCAPE_CHARACTER = "`";
    protected static final String MYSQL_DRIVER = DatabaseEngineDriver.MYSQL.driver();
    public static final int TABLE_NAME_ALREADY_EXISTS = 1050;
    public static final int DUPLICATE_KEY_NAME = 1061;
    public static final int TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = 1068;
    public static final int TABLE_DOES_NOT_EXIST = 1051;
    public static final int CONSTRAINT_NAME_ALREADY_EXISTS = 1005;

    public MySqlEngine(Properties properties) throws DatabaseEngineException {
        super(MYSQL_DRIVER, properties, Dialect.MYSQL);
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        try {
            this.setAnsiMode();
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Unable to set session to ANSI", ex);
        }
    }

    private void setAnsiMode() throws SQLException {
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            StringReader sr = new StringReader((String)val);
                            ps.setClob(i, sr);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, 1);
                            break;
                        }
                        ps.setObject(i, 0);
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variable s to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block19: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
            ArrayList<String> columns = new ArrayList<String>();
            String autoIncName = "";
            int numberOfAutoIncs = 0;
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtil.quotize(c.getName(), ESCAPE_CHARACTER));
                column.add(this.translateType(c));
                if (c.isAutoInc()) {
                    autoIncName = c.getName();
                    column.add("AUTO_INCREMENT");
                    ++numberOfAutoIncs;
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(c.getDefaultValue().translateMySQL(this.properties));
                }
                columns.add(StringUtil.join(column, " "));
            }
            if (numberOfAutoIncs > 1) {
                throw new DatabaseEngineException("In MySQL you can only define one auto increment column");
            }
            String pks = "";
            if (numberOfAutoIncs == 1) {
                pks = entity.getPkFields().length == 0 ? ", PRIMARY KEY(" + autoIncName + ")" : ", PRIMARY KEY(" + StringUtil.join(Arrays.asList(entity.getPkFields()), ", ") + ")";
            }
            createTable.add("(" + StringUtil.join(columns, ", ") + pks + ")");
            String createTableStatement = StringUtil.join(createTable, " ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1050) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    break block19;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block16: {
            if (entity.getPkFields().length == 0) {
                return;
            }
            for (DbColumn column : entity.getColumns()) {
                if (!column.isAutoInc()) continue;
                this.logger.debug(dev, "There's already a primary key since you set '{}' to AUTO INCREMENT", (Object)column.getName());
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtil.quotize(pk, ESCAPE_CHARACTER));
            }
            String pkName = MathUtil.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtil.quotize(pkName, ESCAPE_CHARACTER));
            statement.add("PRIMARY KEY");
            statement.add("(" + StringUtil.join(pks, ", ") + ")");
            String addPrimaryKey = StringUtil.join(statement, " ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1068) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    break block16;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        if (entity.getIndexes().isEmpty()) {
            return;
        }
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtil.quotize(column, ESCAPE_CHARACTER));
                columnsForName.add(column);
            }
            String idxName = MathUtil.md5(String.format("%s_%s_IDX", entity.getName(), StringUtil.join(columnsForName, "_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtil.quotize(idxName, ESCAPE_CHARACTER));
            createIndex.add("ON");
            createIndex.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
            createIndex.add("(" + StringUtil.join(columns, ", ") + ")");
            String statement = StringUtil.join(createIndex, " ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1061) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtil.quotize(column.getName(), ESCAPE_CHARACTER));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) continue;
            columns.add(StringUtil.quotize(column.getName(), ESCAPE_CHARACTER));
            values.add("?");
        }
        insertInto.add("(" + StringUtil.join(columns, ", ") + ")");
        insertInto.add("VALUES (" + StringUtil.join(values, ", ") + ")");
        insertIntoWithAutoInc.add("(" + StringUtil.join(columnsWithAutoInc, ", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + StringUtil.join(valuesWithAutoInc, ", ") + ")");
        String statement = StringUtil.join(insertInto, " ");
        String statementWithAutoInt = StringUtil.join(insertIntoWithAutoInc, " ");
        this.logger.trace(statement);
        this.logger.trace(statementWithAutoInt);
        try {
            PreparedStatement ps = this.conn.prepareStatement(statement, 1);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt);
            return new MappedEntity().setInsert(ps).setInsertWithAutoInc(psWithAutoInc);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            this.dropReferringFks(entity);
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s", StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1051) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : columns) {
                cols.add("DROP COLUMN " + StringUtil.quotize(col, ESCAPE_CHARACTER));
            }
            removeColumns.add(StringUtil.join(cols, ","));
            try {
                drop = this.conn.createStatement();
                String query = StringUtil.join(removeColumns, " ");
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1051) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER));
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add("ADD COLUMN");
            column.add(StringUtil.quotize(c.getName(), ESCAPE_CHARACTER));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(c.getDefaultValue().translateMySQL(this.properties));
            }
            cols.add(StringUtil.join(column, " "));
        }
        addColumns.add(StringUtil.join(cols, ","));
        String addColumnsStatement = StringUtil.join(addColumns, " ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String translateType(DbColumn c) throws DatabaseEngineException {
        return TypeTranslationUtils.translateMySqlType(c, this.properties);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry) throws DatabaseEngineException {
        return this.persist(name, entry, true);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        ResultSet generatedKeys = null;
        try {
            this.getConnection();
            MappedEntity me = (MappedEntity)this.entities.get(name);
            if (me == null) {
                throw new DatabaseEngineException(String.format("Unknown entity '%s'", name));
            }
            PreparedStatement ps = null;
            ps = useAutoInc ? ((MappedEntity)this.entities.get(name)).getInsert() : ((MappedEntity)this.entities.get(name)).getInsertWithAutoInc();
            this.entityToPreparedStatement(me.getEntity(), ps, entry, useAutoInc);
            ps.execute();
            long ret = 0L;
            if (useAutoInc) {
                generatedKeys = ps.getGeneratedKeys();
                if (generatedKeys.next()) {
                    ret = generatedKeys.getLong(1);
                }
                generatedKeys.close();
            }
            Long l = ret == 0L ? null : Long.valueOf(ret);
            return l;
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Something went wrong persisting the entity", ex);
        }
        finally {
            try {
                if (generatedKeys != null) {
                    generatedKeys.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing result set.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String s : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtil.quotize(s, ESCAPE_CHARACTER));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtil.quotize(s, ESCAPE_CHARACTER));
            }
            String table = StringUtil.quotize(entity.getName(), ESCAPE_CHARACTER);
            String quotizedLocalColumnsSting = StringUtil.join(quotizedLocalColumns, ", ");
            String quotizedForeignColumnsString = StringUtil.join(quotizedForeignColumns, ", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", table, StringUtil.quotize(MathUtil.md5("FK_" + table + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize()), ESCAPE_CHARACTER), quotizedLocalColumnsSting, StringUtil.quotize(fk.getForeignTable(), ESCAPE_CHARACTER), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
                alterTableStmt.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1005) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getErrorCode());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %d.", entity.getName(), ex.getErrorCode()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void dropFks(String table) throws DatabaseEngineException {
        String schema = StringUtil.stripToNull(this.properties.getSchema());
        ResultSet rs = null;
        try {
            this.getConnection();
            rs = this.conn.getMetaData().getImportedKeys(null, schema, table);
            HashSet<String> fks = new HashSet<String>();
            while (rs.next()) {
                fks.add(rs.getString("FK_NAME"));
            }
            for (String fk : fks) {
                try {
                    this.executeUpdate(String.format("alter table %s drop foreign key %s", StringUtil.quotize(table, this.escapeCharacter()), StringUtil.quotize(fk, this.escapeCharacter())));
                }
                catch (Exception e) {
                    this.logger.warn("Could not drop foreign key '{}' on table '{}'", (Object)fk, (Object)table);
                    this.logger.debug("Could not drop foreign key.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Error dropping foreign key", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropReferringFks(DbEntity entity) throws DatabaseEngineException {
        Statement s = null;
        ResultSet dependentTables = null;
        try {
            s = this.conn.createStatement();
            String sString = String.format("SELECT TABLE_NAME, CONSTRAINT_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE REFERENCED_TABLE_NAME = '%s'", entity.getName());
            this.logger.trace(sString);
            s.executeQuery(sString);
            dependentTables = s.getResultSet();
            while (dependentTables.next()) {
                Statement dropFk = null;
                try {
                    dropFk = this.conn.createStatement();
                    String dropFkString = String.format("ALTER TABLE %s DROP FOREIGN KEY %s", StringUtil.quotize(dependentTables.getString(1), ESCAPE_CHARACTER), StringUtil.quotize(dependentTables.getString(2), ESCAPE_CHARACTER));
                    this.logger.trace(dropFkString);
                    dropFk.executeUpdate(dropFkString);
                }
                catch (SQLException ex) {
                    this.logger.debug(String.format("Unable to drop constraint '%s' in table '%s'", dependentTables.getString(2), dependentTables.getString(1)), (Throwable)ex);
                }
                finally {
                    if (dropFk == null) continue;
                    try {
                        dropFk.close();
                    }
                    catch (Exception e) {
                        this.logger.trace("Error closing statement.", (Throwable)e);
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException(String.format("Unable to drop foreign keys of the tables that depend on '%s'", entity.getName()), ex);
        }
        finally {
            if (dependentTables != null) {
                try {
                    dependentTables.close();
                }
                catch (Throwable e) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    public String commentCharacter() {
        return "#";
    }

    @Override
    public String escapeCharacter() {
        return ESCAPE_CHARACTER;
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new MySqlResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new MySqlResultIterator(ps);
    }
}

