/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.configuration;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbConfigurationException;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.Map;
import java.util.Properties;

public class PdbProperties
extends Properties
implements Cloneable {
    public static final String JDBC = "pdb.jdbc";
    public static final String USERNAME = "pdb.username";
    public static final String PASSWORD = "pdb.password";
    public static final String VARCHAR_SIZE = "pdb.varchar_size";
    public static final String SCHEMA_POLICY = "pdb.schema_policy";
    public static final String ENGINE = "pdb.engine";
    public static final String SCHEMA = "pdb.schema";
    public static final String MAX_IDENTIFIER_SIZE = "pdb.max_identifier_size";
    public static final String MAX_BLOB_SIZE = "pdb.max_blob_size";
    public static final String BLOB_BUFFER_SIZE = "pdb.blob_buffer_size";
    public static final String MAX_NUMBER_OF_RETRIES = "pdb.max_number_retries";
    public static final String RETRY_INTERVAL = "pdb.retry_interval";
    public static final String ISOLATION_LEVEL = "pdb.isolation_level";
    public static final String DRIVER = "pdb.driver";
    public static final String RECONNECT_ON_LOST = "pdb.reconnect_on_lost";
    public static final String ENCRYPTED_PASSWORD = "pdb.encrypted_password";
    public static final String SECRET_LOCATION = "pdb.secret_location";
    public static final String ENCRYPTED_USERNAME = "pdb.encrypted_username";
    public static final String ALLOW_COLUMN_DROP = "pdb.allow_column_drop";

    public PdbProperties(boolean useDefaults) {
        if (useDefaults) {
            this.setProperty(VARCHAR_SIZE, "256");
            this.setProperty(SCHEMA_POLICY, "create");
            this.setProperty(MAX_IDENTIFIER_SIZE, "30");
            this.setProperty(MAX_BLOB_SIZE, "-1");
            this.setProperty(BLOB_BUFFER_SIZE, "1048576");
            this.setProperty(MAX_NUMBER_OF_RETRIES, "-1");
            this.setProperty(RETRY_INTERVAL, "10000");
            this.setProperty(ISOLATION_LEVEL, "read_committed");
            this.setProperty(RECONNECT_ON_LOST, "true");
            this.setProperty(SECRET_LOCATION, "conf/engine/secret/secret.key");
            this.setProperty(ALLOW_COLUMN_DROP, "true");
        }
    }

    public PdbProperties(Properties properties, boolean useDefaults) {
        this(useDefaults);
        this.merge(properties);
    }

    public final void merge(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public boolean isEncryptedUsername() {
        return StringUtil.isBlank(this.getProperty(ENCRYPTED_USERNAME)) == false;
    }

    public boolean isEncryptedPassword() {
        return StringUtil.isBlank(this.getProperty(ENCRYPTED_PASSWORD)) == false;
    }

    public boolean isSchemaCreateDrop() {
        return this.getProperty(SCHEMA_POLICY).equals("create-drop");
    }

    public boolean isSchemaDropCreate() {
        return this.getProperty(SCHEMA_POLICY).equals("drop-create");
    }

    public boolean isSchemaCreate() {
        return this.getProperty(SCHEMA_POLICY).equals("create");
    }

    public boolean isSchemaNone() {
        return this.getProperty(SCHEMA_POLICY).equals("none");
    }

    public int getMaxIdentifierSize() {
        return Integer.parseInt(this.getProperty(MAX_IDENTIFIER_SIZE));
    }

    public int getMaxBlobSize() {
        return Integer.parseInt(this.getProperty(MAX_BLOB_SIZE));
    }

    public boolean isMaxBlobSizeSet() {
        return this.getMaxBlobSize() != -1;
    }

    public int getBlobBufferSize() {
        return Integer.parseInt(this.getProperty(BLOB_BUFFER_SIZE));
    }

    public int getMaxRetries() {
        return Integer.parseInt(this.getProperty(MAX_NUMBER_OF_RETRIES));
    }

    public long getRetryInterval() {
        return Long.parseLong(this.getProperty(RETRY_INTERVAL));
    }

    public boolean isReconnectOnLost() {
        return Boolean.parseBoolean(this.getProperty(RECONNECT_ON_LOST));
    }

    public int getIsolationLevel() {
        String isolation = this.getProperty(ISOLATION_LEVEL);
        if (isolation.equals("read_uncommitted")) {
            return 1;
        }
        if (isolation.equals("read_committed")) {
            return 2;
        }
        if (isolation.equals("repeatable_read")) {
            return 4;
        }
        if (isolation.equals("serializable")) {
            return 8;
        }
        throw new DatabaseEngineRuntimeException(String.format("Unrecognizable isolation '%s'", isolation));
    }

    public String getJdbc() {
        return this.getProperty(JDBC);
    }

    public String getUsername() {
        return this.getProperty(USERNAME);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD);
    }

    public String getEngine() {
        return this.getProperty(ENGINE);
    }

    public String getSchema() {
        return this.getProperty(SCHEMA);
    }

    public boolean existsSchema() {
        return StringUtil.isBlank(this.getSchema()) == false;
    }

    public boolean allowColumnDrop() {
        return Boolean.parseBoolean(this.getProperty(ALLOW_COLUMN_DROP));
    }

    public void checkMandatoryProperties() throws PdbConfigurationException {
        StringBuilder exceptionMessage = new StringBuilder();
        if (StringUtil.isBlank(this.getJdbc()).booleanValue()) {
            exceptionMessage.append("- A connection string should be declared under the 'database.jdbc' property.\n");
        }
        if (StringUtil.isBlank(this.getEngine()).booleanValue()) {
            exceptionMessage.append("- An engine string should be declared under the 'database.engine' property.\n");
        }
        if (exceptionMessage.length() > 0) {
            throw new PdbConfigurationException("The following configuration errors were detected in the configuration file: \n" + exceptionMessage.toString());
        }
    }

    @Override
    public PdbProperties clone() {
        return new PdbProperties(this, false);
    }
}

