/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseFactoryException;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Properties;

public final class DatabaseFactory {
    private DatabaseFactory() {
    }

    public static DatabaseEngine getConnection(Properties properties) throws DatabaseFactoryException {
        DatabaseEngine de = null;
        String engine = properties.getProperty("pdb.engine");
        if (StringUtil.isBlank(engine).booleanValue()) {
            throw new DatabaseFactoryException("pdb.engine property is mandatory");
        }
        try {
            Class<?> c = Class.forName(engine);
            Constructor<?> cons = c.getConstructor(Properties.class);
            de = (DatabaseEngine)cons.newInstance(properties);
            return de;
        }
        catch (Exception e) {
            throw new DatabaseFactoryException(e);
        }
    }
}

