/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import java.util.EnumSet;

public enum DatabaseEngineDriver {
    H2("H2", "com.feedzai.commons.sql.abstraction.engine.impl.H2Engine", "org.h2.Driver"){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:h2:%s/%s", hostname, database);
        }
    }
    ,
    POSTGRES("Postgres", "com.feedzai.commons.sql.abstraction.engine.impl.PostgreSqlEngine", "org.postgresql.Driver"){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:postgresql://%s/%s", hostname, database);
        }
    }
    ,
    SQLSERVER("SQLServer", "com.feedzai.commons.sql.abstraction.engine.impl.SqlServerEngine", "com.microsoft.sqlserver.jdbc.SQLServerDriver"){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:sqlserver://%s;database=%s", hostname, database);
        }
    }
    ,
    ORACLE("Oracle", "com.feedzai.commons.sql.abstraction.engine.impl.OracleEngine", "oracle.jdbc.OracleDriver"){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:oracle:thin:@%s:1521:%s", hostname, database);
        }
    }
    ,
    MYSQL("MySQL", "com.feedzai.commons.sql.abstraction.engine.impl.MySqlEngine", "com.mysql.jdbc.Driver"){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:mysql://%s/%s", hostname, database);
        }
    }
    ,
    DB2("DB2", "com.feedzai.commons.sql.abstraction.engine.impl.DB2Engine", "com.ibm.db2.jcc.DB2Driver"){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:db2://%s:50000/%s", hostname, database);
        }
    };

    private String name;
    private String engineClass;
    private String driverClass;

    private DatabaseEngineDriver(String name, String engine, String driver) {
        this.name = name;
        this.engineClass = engine;
        this.driverClass = driver;
    }

    public static DatabaseEngineDriver fromEngine(String engine) {
        for (DatabaseEngineDriver element : EnumSet.allOf(DatabaseEngineDriver.class)) {
            if (!element.engineClass.equals(engine)) continue;
            return element;
        }
        return null;
    }

    public static DatabaseEngineDriver fromDriver(String driverClass) {
        for (DatabaseEngineDriver element : EnumSet.allOf(DatabaseEngineDriver.class)) {
            if (!element.driverClass.equals(driverClass)) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String engine() {
        return this.engineClass;
    }

    public String driver() {
        return this.driverClass;
    }

    public abstract String connectionStringFor(String var1, String var2);
}

